/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class DotyHumphreySmallFastCounting64
extends LongProvider {
    private static final int SEED_SIZE = 3;
    private long a;
    private long b;
    private long c;
    private long counter;

    public DotyHumphreySmallFastCounting64(long[] seed) {
        if (seed.length < 3) {
            long[] state = new long[3];
            this.fillState(state, seed);
            this.setSeedInternal(state);
        } else {
            this.setSeedInternal(seed);
        }
    }

    private void setSeedInternal(long[] seed) {
        this.a = seed[0];
        this.b = seed[1];
        this.c = seed[2];
        this.counter = 1L;
        for (int i = 0; i < 18; ++i) {
            this.next();
        }
    }

    @Override
    public final long next() {
        long tmp = this.a + this.b + this.counter++;
        this.a = this.b ^ this.b >>> 11;
        this.b = this.c + (this.c << 3);
        this.c = Long.rotateLeft(this.c, 24) + tmp;
        return tmp;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.a, this.b, this.c, this.counter}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] parts = this.splitStateInternal(s, 32);
        long[] tmp = NumberFactory.makeLongArray(parts[0]);
        this.a = tmp[0];
        this.b = tmp[1];
        this.c = tmp[2];
        this.counter = tmp[3];
        super.setStateInternal(parts[1]);
    }
}

