/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import org.polydev.gaea.libs.commons.rng.JumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.LongJumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.UniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo512
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 8;
    private static final long[] JUMP_COEFFICIENTS = new long[]{3741798284078044153L, 8502941058421957566L, 2898052048139464622L, 5443821109340885276L, -5685015549262525403L, -1027253480086320100L, 6018250552094165679L, 2214584309664130523L};
    private static final long[] LONG_JUMP_COEFFICIENTS = new long[]{1244823013897149736L, -6726097512419258712L, -6329352143493687910L, -5416907637920481567L, 2067315007917389518L, -2785821869681439209L, -7971871629798370372L, 6574356031248116901L};
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;
    protected long state4;
    protected long state5;
    protected long state6;
    protected long state7;

    AbstractXoShiRo512(long[] seed) {
        if (seed.length < 8) {
            long[] state = new long[8];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo512(long seed0, long seed1, long seed2, long seed3, long seed4, long seed5, long seed6, long seed7) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
        this.state4 = seed4;
        this.state5 = seed5;
        this.state6 = seed6;
        this.state7 = seed7;
    }

    protected AbstractXoShiRo512(AbstractXoShiRo512 source) {
        super(source);
        this.state0 = source.state0;
        this.state1 = source.state1;
        this.state2 = source.state2;
        this.state3 = source.state3;
        this.state4 = source.state4;
        this.state5 = source.state5;
        this.state6 = source.state6;
        this.state7 = source.state7;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
        this.state4 = state[4];
        this.state5 = state[5];
        this.state6 = state[6];
        this.state7 = state[7];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3, this.state4, this.state5, this.state6, this.state7}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 64);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        long result = this.nextOutput();
        long t = this.state1 << 11;
        this.state2 ^= this.state0;
        this.state5 ^= this.state1;
        this.state1 ^= this.state2;
        this.state7 ^= this.state3;
        this.state3 ^= this.state4;
        this.state4 ^= this.state5;
        this.state0 ^= this.state6;
        this.state6 ^= this.state7;
        this.state6 ^= t;
        this.state7 = Long.rotateLeft(this.state7, 21);
        return result;
    }

    protected abstract long nextOutput();

    @Override
    public UniformRandomProvider jump() {
        AbstractXoShiRo512 copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        AbstractXoShiRo512 copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    protected abstract AbstractXoShiRo512 copy();

    private void performJump(long[] jumpCoefficients) {
        long s0 = 0L;
        long s1 = 0L;
        long s2 = 0L;
        long s3 = 0L;
        long s4 = 0L;
        long s5 = 0L;
        long s6 = 0L;
        long s7 = 0L;
        for (long jc : jumpCoefficients) {
            for (int b = 0; b < 64; ++b) {
                if ((jc & 1L << b) != 0L) {
                    s0 ^= this.state0;
                    s1 ^= this.state1;
                    s2 ^= this.state2;
                    s3 ^= this.state3;
                    s4 ^= this.state4;
                    s5 ^= this.state5;
                    s6 ^= this.state6;
                    s7 ^= this.state7;
                }
                this.next();
            }
        }
        this.state0 = s0;
        this.state1 = s1;
        this.state2 = s2;
        this.state3 = s3;
        this.state4 = s4;
        this.state5 = s5;
        this.state6 = s6;
        this.state7 = s7;
        this.resetCachedState();
    }
}

