/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import org.polydev.gaea.libs.commons.rng.JumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.LongJumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.UniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

abstract class AbstractXoRoShiRo128
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 2;
    private static final long[] JUMP_COEFFICIENTS = new long[]{-2337365368286915419L, 1659688472399708668L};
    private static final long[] LONG_JUMP_COEFFICIENTS = new long[]{-3266927057705177477L, -2459076376072127807L};
    protected long state0;
    protected long state1;

    AbstractXoRoShiRo128(long[] seed) {
        if (seed.length < 2) {
            long[] state = new long[2];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoRoShiRo128(long seed0, long seed1) {
        this.state0 = seed0;
        this.state1 = seed1;
    }

    protected AbstractXoRoShiRo128(AbstractXoRoShiRo128 source) {
        super(source);
        this.state0 = source.state0;
        this.state1 = source.state1;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        long result = this.nextOutput();
        long s0 = this.state0;
        long s1 = this.state1;
        this.state0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.state1 = Long.rotateLeft(s1, 37);
        return result;
    }

    protected abstract long nextOutput();

    @Override
    public UniformRandomProvider jump() {
        AbstractXoRoShiRo128 copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        AbstractXoRoShiRo128 copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    protected abstract AbstractXoRoShiRo128 copy();

    final void performJump(long[] jumpCoefficients) {
        long s0 = 0L;
        long s1 = 0L;
        for (long jc : jumpCoefficients) {
            for (int b = 0; b < 64; ++b) {
                if ((jc & 1L << b) != 0L) {
                    s0 ^= this.state0;
                    s1 ^= this.state1;
                }
                this.next();
            }
        }
        this.state0 = s0;
        this.state1 = s1;
        this.resetCachedState();
    }
}

