/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import java.util.Arrays;
import org.polydev.gaea.libs.commons.rng.JumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.LongJumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.UniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

abstract class AbstractXoRoShiRo1024
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 16;
    private static final long[] JUMP_COEFFICIENTS = new long[]{-7849325717751365865L, -5362622907718333345L, -1122967529567393605L, -6000863704620854271L, 1310634114059809896L, -5197181425261377250L, 4637439795396209428L, 3813095890516987466L, -2241461938891922586L, -8122543571224427081L, 3642273948006143743L, -3963889281946157117L, -1686083133252405678L, 5040521015619105285L, 253977588014850237L, -6444753840407202940L};
    private static final long[] LONG_JUMP_COEFFICIENTS = new long[]{8319297928229023759L, 5057756716036506102L, 7373545129600583345L, -7712484954037348767L, 2871084607885011757L, -7565639389704146929L, 3398312999033111725L, -6457736231335962442L, 7505262487910875276L, 5788604780749952089L, 3441325262644128410L, 5267131003631869839L, -7879509573797335871L, -835381597232840406L, 5958275733011374469L, 2187407462152143809L};
    private final long[] state = new long[16];
    private int index;

    AbstractXoRoShiRo1024(long[] seed) {
        this.setSeedInternal(seed);
    }

    protected AbstractXoRoShiRo1024(AbstractXoRoShiRo1024 source) {
        super(source);
        System.arraycopy(source.state, 0, this.state, 0, 16);
        this.index = source.index;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = Arrays.copyOf(this.state, 17);
        s[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 136);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.state, 0, 16);
        this.index = (int)tmp[16];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(long[] seed) {
        this.fillState(this.state, seed);
        this.index = 0;
    }

    @Override
    public long next() {
        int q = this.index;
        this.index = this.index + 1 & 0xF;
        long s0 = this.state[this.index];
        long s15 = this.state[q];
        long result = this.transform(s0, s15);
        this.state[q] = Long.rotateLeft(s0, 25) ^ (s15 ^= s0) ^ s15 << 27;
        this.state[this.index] = Long.rotateLeft(s15, 36);
        return result;
    }

    protected abstract long transform(long var1, long var3);

    @Override
    public UniformRandomProvider jump() {
        AbstractXoRoShiRo1024 copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        AbstractXoRoShiRo1024 copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    protected abstract AbstractXoRoShiRo1024 copy();

    private void performJump(long[] jumpCoefficients) {
        long[] newState = new long[16];
        for (long jc : jumpCoefficients) {
            for (int b = 0; b < 64; ++b) {
                if ((jc & 1L << b) != 0L) {
                    for (int i = 0; i < 16; ++i) {
                        int n = i;
                        newState[n] = newState[n] ^ this.state[i + this.index & 0xF];
                    }
                }
                this.next();
            }
        }
        for (int j = 0; j < 16; ++j) {
            this.state[j + this.index & 0xF] = newState[j];
        }
        this.resetCachedState();
    }
}

