/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source32;

import java.util.Arrays;
import org.polydev.gaea.libs.commons.rng.core.source32.IntProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class MultiplyWithCarry256
extends IntProvider {
    private static final int Q_SIZE = 256;
    private static final int SEED_SIZE = 257;
    private static final long A = 809430660L;
    private final int[] state = new int[256];
    private int index;
    private int carry;

    public MultiplyWithCarry256(int[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] s = Arrays.copyOf(this.state, 258);
        s[256] = this.carry;
        s[257] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 1032);
        int[] tmp = NumberFactory.makeIntArray(c[0]);
        System.arraycopy(tmp, 0, this.state, 0, 256);
        this.carry = tmp[256];
        this.index = tmp[257];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(int[] seed) {
        int[] tmp = new int[257];
        this.fillState(tmp, seed);
        int c = tmp[0];
        this.carry = (int)((long)Math.abs(c) % 809430660L);
        System.arraycopy(tmp, 1, this.state, 0, 256);
        this.index = 256;
    }

    @Override
    public int next() {
        this.index &= 0xFF;
        long t = 809430660L * ((long)this.state[this.index] & 0xFFFFFFFFL) + (long)this.carry;
        this.carry = (int)(t >> 32);
        int n = (int)t;
        this.state[this.index++] = n;
        return n;
    }
}

