/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source32;

import java.util.Arrays;
import org.polydev.gaea.libs.commons.rng.core.source32.IntProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class MiddleSquareWeylSequence
extends IntProvider {
    private static final int SEED_SIZE = 3;
    private static final long[] DEFAULT_SEED = new long[]{84972160111362308L, -4029002846318278299L, -5355537731544096087L};
    private long x;
    private long w;
    private long s;

    public MiddleSquareWeylSequence(long[] seed) {
        if (seed.length < 3) {
            long[] tmp = Arrays.copyOf(seed, 3);
            System.arraycopy(DEFAULT_SEED, seed.length, tmp, seed.length, 3 - seed.length);
            this.setSeedInternal(tmp);
        } else {
            this.setSeedInternal(seed);
        }
    }

    private void setSeedInternal(long[] seed) {
        this.x = seed[0];
        this.w = seed[1];
        this.s = seed[2] | 1L;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.x, this.w, this.s}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] state) {
        byte[][] c = this.splitStateInternal(state, 24);
        this.setSeedInternal(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public int next() {
        this.x *= this.x;
        this.x += (this.w += this.s);
        this.x = this.x >>> 32 | this.x << 32;
        return (int)this.x;
    }

    @Override
    public long nextLong() {
        this.x *= this.x;
        this.x += (this.w += this.s);
        long i1 = this.x & 0xFFFFFFFF00000000L;
        this.x = this.x >>> 32 | this.x << 32;
        this.x *= this.x;
        this.x += (this.w += this.s);
        long i2 = this.x >>> 32;
        this.x = i2 | this.x << 32;
        return i1 | i2;
    }
}

