/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source32;

import java.util.Arrays;
import org.polydev.gaea.libs.commons.rng.core.source32.IntProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class ISAACRandom
extends IntProvider {
    private static final int SIZE_L = 8;
    private static final int SIZE = 256;
    private static final int H_SIZE = 128;
    private static final int MASK = 1020;
    private static final int GLD_RATIO = -1640531527;
    private final int[] rsl = new int[256];
    private final int[] mem = new int[256];
    private int count;
    private int isaacA;
    private int isaacB;
    private int isaacC;
    private final int[] arr = new int[8];
    private int isaacX;
    private int isaacI;
    private int isaacJ;

    public ISAACRandom(int[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] sRsl = Arrays.copyOf(this.rsl, 256);
        int[] sMem = Arrays.copyOf(this.mem, 256);
        int[] sRem = Arrays.copyOf(new int[]{this.count, this.isaacA, this.isaacB, this.isaacC}, 4);
        int[] s = new int[512 + sRem.length];
        System.arraycopy(sRsl, 0, s, 0, 256);
        System.arraycopy(sMem, 0, s, 256, 256);
        System.arraycopy(sRem, 0, s, 512, sRem.length);
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 2064);
        int[] tmp = NumberFactory.makeIntArray(c[0]);
        System.arraycopy(tmp, 0, this.rsl, 0, 256);
        System.arraycopy(tmp, 256, this.mem, 0, 256);
        int offset = 512;
        this.count = tmp[512];
        this.isaacA = tmp[513];
        this.isaacB = tmp[514];
        this.isaacC = tmp[515];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(int[] seed) {
        int seedLen = seed.length;
        int rslLen = this.rsl.length;
        System.arraycopy(seed, 0, this.rsl, 0, Math.min(seedLen, rslLen));
        if (seedLen < rslLen) {
            for (int j = seedLen; j < rslLen; ++j) {
                long k = this.rsl[j - seedLen];
                this.rsl[j] = (int)(1812433253L * (k ^ k >> 30) + (long)j & 0xFFFFFFFFL);
            }
        }
        this.initState();
    }

    @Override
    public int next() {
        if (this.count < 0) {
            this.isaac();
            this.count = 255;
        }
        return this.rsl[this.count--];
    }

    private void isaac() {
        this.isaacI = 0;
        this.isaacJ = 128;
        this.isaacB += ++this.isaacC;
        while (this.isaacI < 128) {
            this.isaac2();
        }
        this.isaacJ = 0;
        while (this.isaacJ < 128) {
            this.isaac2();
        }
    }

    private void isaac2() {
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 13;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 6;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 2;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 16;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
    }

    private void isaac3() {
        this.mem[this.isaacI] = this.mem[(this.isaacX & 0x3FC) >> 2] + this.isaacA + this.isaacB;
        this.isaacB = this.mem[(this.mem[this.isaacI] >> 8 & 0x3FC) >> 2] + this.isaacX;
        this.rsl[this.isaacI++] = this.isaacB;
    }

    private void initState() {
        int j;
        this.isaacA = 0;
        this.isaacB = 0;
        this.isaacC = 0;
        for (j = 0; j < this.arr.length; ++j) {
            this.arr[j] = -1640531527;
        }
        for (j = 0; j < 4; ++j) {
            this.shuffle();
        }
        for (j = 0; j < 256; j += 8) {
            this.arr[0] = this.arr[0] + this.rsl[j];
            this.arr[1] = this.arr[1] + this.rsl[j + 1];
            this.arr[2] = this.arr[2] + this.rsl[j + 2];
            this.arr[3] = this.arr[3] + this.rsl[j + 3];
            this.arr[4] = this.arr[4] + this.rsl[j + 4];
            this.arr[5] = this.arr[5] + this.rsl[j + 5];
            this.arr[6] = this.arr[6] + this.rsl[j + 6];
            this.arr[7] = this.arr[7] + this.rsl[j + 7];
            this.shuffle();
            this.setState(j);
        }
        for (j = 0; j < 256; j += 8) {
            this.arr[0] = this.arr[0] + this.mem[j];
            this.arr[1] = this.arr[1] + this.mem[j + 1];
            this.arr[2] = this.arr[2] + this.mem[j + 2];
            this.arr[3] = this.arr[3] + this.mem[j + 3];
            this.arr[4] = this.arr[4] + this.mem[j + 4];
            this.arr[5] = this.arr[5] + this.mem[j + 5];
            this.arr[6] = this.arr[6] + this.mem[j + 6];
            this.arr[7] = this.arr[7] + this.mem[j + 7];
            this.shuffle();
            this.setState(j);
        }
        this.isaac();
        this.count = 255;
    }

    private void shuffle() {
        this.arr[0] = this.arr[0] ^ this.arr[1] << 11;
        this.arr[3] = this.arr[3] + this.arr[0];
        this.arr[1] = this.arr[1] + this.arr[2];
        this.arr[1] = this.arr[1] ^ this.arr[2] >>> 2;
        this.arr[4] = this.arr[4] + this.arr[1];
        this.arr[2] = this.arr[2] + this.arr[3];
        this.arr[2] = this.arr[2] ^ this.arr[3] << 8;
        this.arr[5] = this.arr[5] + this.arr[2];
        this.arr[3] = this.arr[3] + this.arr[4];
        this.arr[3] = this.arr[3] ^ this.arr[4] >>> 16;
        this.arr[6] = this.arr[6] + this.arr[3];
        this.arr[4] = this.arr[4] + this.arr[5];
        this.arr[4] = this.arr[4] ^ this.arr[5] << 10;
        this.arr[7] = this.arr[7] + this.arr[4];
        this.arr[5] = this.arr[5] + this.arr[6];
        this.arr[5] = this.arr[5] ^ this.arr[6] >>> 4;
        this.arr[0] = this.arr[0] + this.arr[5];
        this.arr[6] = this.arr[6] + this.arr[7];
        this.arr[6] = this.arr[6] ^ this.arr[7] << 8;
        this.arr[1] = this.arr[1] + this.arr[6];
        this.arr[7] = this.arr[7] + this.arr[0];
        this.arr[7] = this.arr[7] ^ this.arr[0] >>> 9;
        this.arr[2] = this.arr[2] + this.arr[7];
        this.arr[0] = this.arr[0] + this.arr[1];
    }

    private void setState(int start) {
        this.mem[start] = this.arr[0];
        this.mem[start + 1] = this.arr[1];
        this.mem[start + 2] = this.arr[2];
        this.mem[start + 3] = this.arr[3];
        this.mem[start + 4] = this.arr[4];
        this.mem[start + 5] = this.arr[5];
        this.mem[start + 6] = this.arr[6];
        this.mem[start + 7] = this.arr[7];
    }
}

