/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.generation;

import java.util.List;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import org.polydev.gaea.biome.Biome;
import org.polydev.gaea.biome.BiomeGrid;
import org.polydev.gaea.generation.GenerationPhase;
import org.polydev.gaea.generation.GenerationPopulator;
import org.polydev.gaea.math.ChunkInterpolator;
import org.polydev.gaea.math.FastNoiseLite;
import org.polydev.gaea.profiler.ProfileFuture;
import org.polydev.gaea.profiler.WorldProfiler;

public abstract class GaeaChunkGenerator
extends ChunkGenerator {
    private final ChunkInterpolator.InterpolationType interpolationType;
    private FastNoiseLite gen;
    private WorldProfiler profiler;

    public GaeaChunkGenerator(ChunkInterpolator.InterpolationType type) {
        this.interpolationType = type;
    }

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biome) {
        try (ProfileFuture ignore = this.measure("TotalChunkGenTime");){
            ChunkGenerator.ChunkData chunk;
            ChunkInterpolator interp;
            if (this.gen == null) {
                this.gen = new FastNoiseLite((int)world.getSeed());
                this.gen.setNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
                this.gen.setFractalType(FastNoiseLite.FractalType.FBm);
                this.gen.setFractalOctaves(this.getNoiseOctaves(world));
                this.gen.setFrequency(this.getNoiseFrequency(world));
            }
            try (ProfileFuture ignored = this.measure("ChunkBaseGenTime");){
                interp = this.interpolationType.getInstance(world, chunkX, chunkZ, this.getBiomeGrid(world), this.gen);
                chunk = this.generateBase(world, random, chunkX, chunkZ, interp);
            }
            ignored = this.measure("BiomeApplyTime");
            var11_9 = null;
            try {
                BiomeGrid grid = this.getBiomeGrid(world);
                int xOrig = chunkX << 4;
                int zOrig = chunkZ << 4;
                for (int x = 0; x < 4; x = (int)((byte)(x + 1))) {
                    for (int z = 0; z < 4; z = (int)((byte)(z + 1))) {
                        int cx = xOrig + (x << 2);
                        int cz = zOrig + (z << 2);
                        Biome b = grid.getBiome(cx, cz, GenerationPhase.PALETTE_APPLY);
                        biome.setBiome(x << 2, z << 2, b.getVanillaBiome());
                    }
                }
            }
            catch (Throwable throwable) {
                var11_9 = throwable;
                throw throwable;
            }
            finally {
                if (ignored != null) {
                    if (var11_9 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var11_9.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            for (GenerationPopulator g : this.getGenerationPopulators(world)) {
                g.populate(world, chunk, random, chunkX, chunkZ, interp);
            }
            ChunkGenerator.ChunkData chunkData = chunk;
            return chunkData;
        }
    }

    public void attachProfiler(WorldProfiler p) {
        this.profiler = p;
    }

    public WorldProfiler getProfiler() {
        return this.profiler;
    }

    private ProfileFuture measure(String id) {
        if (this.profiler != null) {
            return this.profiler.measure(id);
        }
        return null;
    }

    public abstract ChunkGenerator.ChunkData generateBase(@NotNull World var1, @NotNull Random var2, int var3, int var4, ChunkInterpolator var5);

    public abstract int getNoiseOctaves(World var1);

    public abstract double getNoiseFrequency(World var1);

    public abstract List<GenerationPopulator> getGenerationPopulators(World var1);

    public abstract BiomeGrid getBiomeGrid(World var1);

    public FastNoiseLite getNoiseGenerator() {
        return this.gen;
    }
}

