/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.polydev.gaea.GaeaPlugin;
import org.polydev.gaea.command.DebugCommand;

public abstract class Command
implements CommandExecutor,
TabCompleter {
    private final GaeaPlugin main;

    public Command(GaeaPlugin main) {
        this.main = main;
    }

    public Command(Command parent) {
        this.main = parent.getMain();
    }

    public GaeaPlugin getMain() {
        return this.main;
    }

    public abstract String getName();

    public abstract List<Command> getSubCommands();

    public abstract boolean execute(@NotNull CommandSender var1, @NotNull org.bukkit.command.Command var2, @NotNull String var3, @NotNull String[] var4);

    public abstract int arguments();

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String label, @NotNull String[] args) {
        if (this instanceof DebugCommand && !this.main.isDebug()) {
            this.main.getLanguage().send("command.debug-only", sender, new String[0]);
            return true;
        }
        if (args.length > 0) {
            for (Command c : this.getSubCommands()) {
                if (!c.getName().equals(args[0])) continue;
                return c.onCommand(sender, command, label, (String[])Arrays.stream(args, 1, args.length).toArray(String[]::new));
            }
            if (args.length != this.arguments()) {
                this.main.getLanguage().send("command.invalid", sender, String.valueOf(this.arguments()), String.valueOf(args.length));
                return true;
            }
            return this.execute(sender, command, label, args);
        }
        if (args.length != this.arguments()) {
            this.main.getLanguage().send("command.invalid", sender, String.valueOf(this.arguments()), String.valueOf(args.length));
            return true;
        }
        return this.execute(sender, command, label, new String[0]);
    }

    public abstract List<String> getTabCompletions(@NotNull CommandSender var1, @NotNull String var2, @NotNull String[] var3);

    @Nullable
    public final List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> complete = new ArrayList<String>();
        if (args.length > 0) {
            for (Command c : this.getSubCommands()) {
                if (c.getName().startsWith(args[0])) {
                    complete.add(c.getName());
                }
                if (!c.getName().equals(args[0])) continue;
                return c.onTabComplete(sender, command, alias, (String[])Arrays.stream(args, 1, args.length).toArray(String[]::new));
            }
        }
        complete.addAll(this.getTabCompletions(sender, alias, args));
        return complete;
    }
}

