/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.biome;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.structures.Structure;
import org.polydev.gaea.tree.Tree;
import org.polydev.gaea.world.Flora;

public abstract class Decorator {
    private final Map<String, ProbabilityCollection<Structure>> worldStructureProb = new HashMap<String, ProbabilityCollection<Structure>>();

    public ProbabilityCollection<Structure> getStructures(World w) {
        return this.worldStructureProb.containsKey(w.getName()) ? this.worldStructureProb.get(w.getName()) : new ProbabilityCollection<Structure>();
    }

    public abstract ProbabilityCollection<Tree> getTrees();

    public abstract int getTreeDensity();

    public abstract boolean overrideStructureChance();

    public abstract Biome getVanillaBiome();

    public abstract ProbabilityCollection<Flora> getFlora();

    public abstract int getFloraChance();

    public void setStructures(ProbabilityCollection<Structure> structures, World w) {
        this.worldStructureProb.put(w.getName(), structures);
    }

    public void setStructures(ProbabilityCollection<Structure> structures, String w) {
        this.worldStructureProb.put(w, structures);
    }
}

