/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.biome;

import org.bukkit.Location;
import org.bukkit.World;
import org.polydev.gaea.biome.Biome;
import org.polydev.gaea.biome.NormalizationUtil;
import org.polydev.gaea.generation.GenerationPhase;
import org.polydev.gaea.math.FastNoiseLite;

public abstract class BiomeGrid {
    private final FastNoiseLite noiseX;
    private final FastNoiseLite noiseZ;
    private final World world;
    private final int sizeX;
    private final int sizeZ;
    private Biome[][] grid;

    public BiomeGrid(World w, double freq1, double freq2, int sizeX, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.world = w;
        this.noiseX = new FastNoiseLite((int)w.getSeed());
        this.noiseZ = new FastNoiseLite((int)w.getSeed() + 1);
        this.noiseX.setNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.noiseX.setFractalType(FastNoiseLite.FractalType.FBm);
        this.noiseX.setFractalOctaves(4);
        this.noiseZ.setNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.noiseZ.setFractalType(FastNoiseLite.FractalType.FBm);
        this.noiseZ.setFractalOctaves(4);
        this.noiseX.setFrequency(freq1);
        this.noiseZ.setFrequency(freq2);
    }

    public Biome getBiome(int x, int z, GenerationPhase phase) {
        return this.grid[this.getBiomeNoiseX(x, z)][this.getBiomeNoiseZ(x, z)];
    }

    public Biome getBiome(Location l) {
        return this.getBiome(l, GenerationPhase.POST_GEN);
    }

    public double[] getRawNoise(int x, int z) {
        return new double[]{this.noiseX.getNoise(x, z), this.noiseZ.getNoise(x, z)};
    }

    public int getBiomeNoiseX(int x, int z) {
        return this.normalize(this.noiseX.getNoise(x, z), this.sizeX);
    }

    public int getBiomeNoiseZ(int x, int z) {
        return this.normalize(this.noiseZ.getNoise(x, z), this.sizeZ);
    }

    public Biome[][] getGrid() {
        return this.grid;
    }

    public void setGrid(Biome[][] grid) {
        if (grid.length != this.sizeX) {
            throw new IllegalArgumentException("Invalid length for grid, expected " + this.sizeX + ", got " + grid.length);
        }
        for (Biome[] gridLayer : grid) {
            if (gridLayer.length == this.sizeZ) continue;
            throw new IllegalArgumentException("Invalid length for grid layer, expected " + this.sizeZ + ", got " + gridLayer.length);
        }
        this.grid = grid;
    }

    public Biome getBiome(Location l, GenerationPhase phase) {
        double biomeNoise = this.noiseX.getNoise(l.getBlockX(), l.getBlockZ());
        double climateNoise = this.noiseZ.getNoise(l.getBlockX(), l.getBlockZ());
        return this.grid[this.normalize(biomeNoise, this.sizeX)][this.normalize(climateNoise, this.sizeZ)];
    }

    public World getWorld() {
        return this.world;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    protected int normalize(double i, int range) {
        return NormalizationUtil.normalize(i, range, 4);
    }
}

