/*
 * Decompiled with CFR 0.152.
 */
package gui;

import assets.ConfigHandler;
import assets.PlayerData;
import assets.Ranks;
import de.marvnet.gtm.Main;
import me.confuser.barapi.BarAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Phone {
    public static ItemStack createItem(String name, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta imeta = item.getItemMeta();
        imeta.setDisplayName(name);
        item.setItemMeta(imeta);
        return item;
    }

    public static void giveItem(Player p, String name, Material material) {
        p.getInventory().addItem(new ItemStack[]{Phone.createItem(name, material)});
    }

    public static void orderItem(final Player p, final String name, final Material material, final int price) {
        p.sendMessage(Main.orderWaitMessage);
        BarAPI.setMessage((Player)p, (String)Main.orderWaitMessage, (int)((Integer)ConfigHandler.getConfigValue("order.waitdelay")));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, new Runnable(){

            @Override
            public void run() {
                PlayerData.minusLocal(p, price);
                Phone.giveItem(p, name, material);
                p.sendMessage(Main.orderDelivered);
            }
        }, (long)((Integer)ConfigHandler.getConfigValue("order.waitdelay") * 20));
    }

    public static Inventory getPhone(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00a76\u00a7lPhone");
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.DARK_GREEN + "\u00a7lMoney", Material.PAPER)});
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a74\u00a7lOnline-Shopping", Material.COOKED_CHICKEN)});
        return inv;
    }

    public static Inventory getMoney(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)(ChatColor.DARK_GREEN + "\u00a7lMoney"));
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.RED + "\u00a7lBack", Material.BARRIER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.DARK_GREEN + "\u00a7lOnline-Banking", Material.PAPER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.AQUA + "\u00a7lPurse: " + ChatColor.DARK_AQUA + "\u00a7l" + Integer.toString(PlayerData.getLocal(p)) + "$", Material.PAPER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.AQUA + "\u00a7lBank: " + ChatColor.DARK_AQUA + "\u00a7l" + Integer.toString(PlayerData.getBank(p)) + "$", Material.PAPER)});
        return inv;
    }

    public static Inventory getBanking(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)(ChatColor.DARK_GREEN + "\u00a7lOnline-Banking"));
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.RED + "\u00a7lBack", Material.BARRIER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.DARK_GREEN + "\u00a7lKontostand: \u00a73\u00a7l" + Integer.toString(PlayerData.getBank(p)) + "$", Material.SLIME_BALL)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.DARK_GREEN + "\u00a7lTransmit all to bank", Material.SLIME_BALL)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.DARK_GREEN + "\u00a7lTransmit all to purse", Material.SLIME_BALL)});
        return inv;
    }

    public static Inventory getShopOverview(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00a74\u00a7lShop: Overview");
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a74\u00a7lBack", Material.BARRIER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.GRAY + "\u00a7lFood", Material.COOKED_CHICKEN)});
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a78\u00a7lWeapons", Material.WOOD_AXE)});
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a78\u00a7lRanks", Material.GOLDEN_APPLE)});
        return inv;
    }

    public static Inventory getShopWeapons(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00a74\u00a7lShop: Weapons");
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a74\u00a7lBack", Material.BARRIER)});
        inv.addItem(new ItemStack[]{Phone.createItem((String)ConfigHandler.getWeaponValue("sniper", "shopname"), Material.IRON_HOE)});
        inv.addItem(new ItemStack[]{Phone.createItem((String)ConfigHandler.getWeaponValue("rocketlauncher", "shopname"), Material.WOOD_HOE)});
        inv.addItem(new ItemStack[]{Phone.createItem((String)ConfigHandler.getWeaponValue("pistol", "shopname"), Material.WOOD_AXE)});
        return inv;
    }

    public static Inventory getShopFood(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00a74\u00a7lShop: Food");
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a74\u00a7lBack", Material.BARRIER)});
        inv.addItem(new ItemStack[]{Phone.createItem(ChatColor.GREEN + "\u00a7lPotato: \u00a7850$", Material.BAKED_POTATO)});
        return inv;
    }

    public static Inventory getShopRanks(Player p) {
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)"\u00a74\u00a7lShop: Ranks");
        inv.addItem(new ItemStack[]{Phone.createItem("\u00a74\u00a7lBack", Material.BARRIER)});
        for (String rank : Ranks.getRanks()) {
            inv.addItem(new ItemStack[]{Phone.createItem(Ranks.getShopName(rank), Material.GOLDEN_APPLE)});
        }
        return inv;
    }
}

