/*
 * Decompiled with CFR 0.152.
 */
package assets;

import assets.ConfigHandler;
import de.marvnet.gtm.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerData {
    public static YamlConfiguration getConfig(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg;
    }

    public static File getConfigFile(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        return playerFile;
    }

    public static void init(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        if (!playerFile.exists()) {
            try {
                playerFile.createNewFile();
                PlayerData.createDefaultValues(p);
                p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aYou've received \u00a72$" + ConfigHandler.getConfigValue("default.money") + "\u00a7a from the state!");
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated player file for '" + p.getName() + "'!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void createDefaultValues(Player p) {
        YamlConfiguration cfg = PlayerData.getConfig(p);
        cfg.set("money.bank", (Object)0);
        cfg.set("money.local", ConfigHandler.getConfigValue("default.money"));
        cfg.set("rank.name", ConfigHandler.getConfigValue("default.rank"));
        cfg.set("prefix.player", ConfigHandler.getConfigValue("default.prefix.player"));
        cfg.set("prefix.message", ConfigHandler.getConfigValue("default.prefix.message"));
        cfg.set("special.hasrank", (Object)false);
        cfg.set("special.rank", (Object)"");
        try {
            cfg.save(PlayerData.getConfigFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getBank(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.getInt("money.bank");
    }

    public static int getLocal(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.getInt("money.local");
    }

    public static void resetBank(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        cfg.set("money.bank", (Object)0);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetLocal(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        cfg.set("money.local", (Object)0);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addBank(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int moneya = cfg.getInt("money.bank");
        int summe = Integer.sum(moneya, money);
        cfg.set("money.bank", (Object)summe);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void minusBank(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int moneya = cfg.getInt("money.bank");
        int summe = moneya - money;
        cfg.set("money.bank", (Object)summe);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addLocal(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int moneya = cfg.getInt("money.local");
        int summe = Integer.sum(moneya, money);
        cfg.set("money.local", (Object)summe);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void minusLocal(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int moneya = cfg.getInt("money.local");
        int summe = moneya - money;
        cfg.set("money.local", (Object)summe);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void localToBank(Player p) {
        PlayerData.addBank(p, PlayerData.getLocal(p));
        int moneylocal = PlayerData.getLocal(p);
        PlayerData.resetLocal(p);
        p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aTransmitted \u00a72" + moneylocal + "$ \u00a7ato your Bank!");
    }

    public static void bankToLocal(Player p) {
        PlayerData.addLocal(p, PlayerData.getBank(p));
        int moneylocal = PlayerData.getBank(p);
        PlayerData.resetBank(p);
        p.sendMessage(String.valueOf(Main.prefix) + "\u00a7aTransmitted \u00a72" + moneylocal + "$ \u00a7ato your purse!");
    }

    public static String getRank(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.getString("rank.name");
    }

    public static Object getValue(Player p, String string) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.get(string);
    }

    public static boolean hasEnoughLocal(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int currmoney = cfg.getInt("money.local");
        return currmoney >= money;
    }

    public static boolean hasEnoughBank(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        int currmoney = cfg.getInt("money.bank");
        return currmoney >= money;
    }

    public static void setLocal(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        cfg.set("money.local", (Object)money);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setbank(Player p, int money) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        cfg.set("money.bank", (Object)money);
        try {
            cfg.save(playerFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSpecial(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.getBoolean("special.hasrank");
    }

    public static String getSpecialRank(Player p) {
        File playerFile = new File("plugins/GTM/player/" + p.getUniqueId() + ".yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)playerFile);
        return cfg.getString("special.rank");
    }
}

