/*
 * Decompiled with CFR 0.152.
 */
package assets;

import de.marvnet.gtm.Main;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler {
    public static void initFiles() {
        File weaponFile;
        File rankFile;
        File configFile;
        File playerDir;
        File mainDir = new File("plugins/GTM");
        if (mainDir.exists()) {
            if (!mainDir.isDirectory()) {
                mainDir.delete();
                mainDir.mkdir();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated 'GTM' directory!");
            }
        } else {
            mainDir.mkdir();
        }
        if ((playerDir = new File("plugins/GTM/player")).exists()) {
            if (!playerDir.isDirectory()) {
                playerDir.delete();
                playerDir.mkdir();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated 'GTM/player' directory!");
            }
        } else {
            playerDir.mkdir();
        }
        if (!(configFile = new File("plugins/GTM/config.yml")).exists()) {
            try {
                configFile.createNewFile();
                ConfigHandler.setConfigDefaults();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated config file!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(rankFile = new File("plugins/GTM/ranks.yml")).exists()) {
            try {
                rankFile.createNewFile();
                ConfigHandler.setRankDefaults();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated ranks file!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(weaponFile = new File("plugins/GTM/weapons.yml")).exists()) {
            try {
                weaponFile.createNewFile();
                ConfigHandler.setWeaponDefaults();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(Main.prefix) + "\u00a7aCreated weapon file!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setRankDefaults() {
        File rankFile = new File("plugins/GTM/ranks.yml");
        YamlConfiguration ranks = YamlConfiguration.loadConfiguration((File)rankFile);
        ranks.set("HOBO.name", (Object)"HOBO");
        ranks.set("HOBO.prefix", (Object)"\u00a76\u00a7l");
        ranks.set("HOBO.pexname", (Object)"hobo");
        ranks.set("HOBO.shopname", (Object)"\u00a76\u00a7lHOBO\u00a7f: \u00a71000$");
        ranks.set("HOBO.price", (Object)1000);
        ranks.set("GODFATHER.name", (Object)"GODFATHER");
        ranks.set("GODFATHER.prefix", (Object)(ChatColor.DARK_PURPLE + "\u00a7l"));
        ranks.set("GODFATHER.pexname", (Object)"godfather");
        ranks.set("GODFATHER.shopname", (Object)(ChatColor.DARK_PURPLE + "\u00a7lGODFATHER\u00a7f: \u00a7810000$"));
        ranks.set("GODFATHER.price", (Object)10000);
        try {
            ranks.save(rankFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void setWeaponDefaults() {
        File weaponFile = new File("plugins/GTM/weapons.yml");
        YamlConfiguration weapons = YamlConfiguration.loadConfiguration((File)weaponFile);
        weapons.set("sniper.name", (Object)"\u00a73Sniper");
        weapons.set("sniper.damage", (Object)14);
        weapons.set("sniper.shopname", (Object)"\u00a73Sniper\u00a7f: \u00a782500$");
        weapons.set("sniper.price", (Object)2500);
        weapons.set("sniper.loaddelay", (Object)5);
        weapons.set("rocketlauncher.name", (Object)"\u00a74Rocketlauncher");
        weapons.set("rocketlauncher.damage", (Object)25);
        weapons.set("rocketlauncher.shopname", (Object)"\u00a74Rocketlauncher\u00a7f: \u00a7810000$");
        weapons.set("rocketlauncher.price", (Object)10000);
        weapons.set("rocketlauncher.loaddelay", (Object)10);
        weapons.set("pistol.name", (Object)"\u00a78Pistol");
        weapons.set("pistol.damage", (Object)4);
        weapons.set("pistol.shopname", (Object)"\u00a78Pistol\u00a7f: \u00a781000$");
        weapons.set("pistol.price", (Object)1000);
        weapons.set("pistol.loaddelay", (Object)1);
        try {
            weapons.save(weaponFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object getWeaponValue(String weapon, String property) {
        File weaponFile = new File("plugins/GTM/weapons.yml");
        YamlConfiguration weapons = YamlConfiguration.loadConfiguration((File)weaponFile);
        return weapons.get(String.valueOf(weapon) + "." + property);
    }

    public static Object getConfigValue(String property) {
        File configFile = new File("plugins/GTM/config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)configFile);
        return cfg.get(property);
    }

    public static Object getConfigValueString(String property) {
        File configFile = new File("plugins/GTM/config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)configFile);
        return cfg.getString(property);
    }

    private static void setConfigDefaults() {
        File configFile = new File("plugins/GTM/config.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)configFile);
        cfg.set("test.test", (Object)"yeah");
        cfg.set("default.money", (Object)3500);
        cfg.set("plugin.prefix", (Object)"\u00a7f[\u00a78GTM\u00a7f] ");
        cfg.set("default.rank", (Object)"HOBO");
        cfg.set("default.prefix.player", (Object)"\u00a78");
        cfg.set("default.prefix.message", (Object)"\u00a7f");
        cfg.set("messages.killmessage.message", (Object)"\u00a7aFor the kill on %s(victim) you received %s(money)!");
        cfg.set("messages.killmessage.send", (Object)true);
        cfg.set("messages.killmessage.mobkill.message", (Object)"\u00a7aFor the kill on a Mob, you received $200!");
        cfg.set("messages.killmessage.mobkill.send", (Object)true);
        cfg.set("messages.nomoney.message", (Object)"\u00a7cNot enough money!");
        cfg.set("messages.order.orderdelivered.message", (Object)(ChatColor.YELLOW + "Your order is delivered!"));
        cfg.set("messages.order.orderwait.message", (Object)(ChatColor.YELLOW + "Please wait 5 seconds..."));
        cfg.set("messages.unhandlederror.message", (Object)"\u00a7cAn unknown error occured!");
        cfg.set("messages.nopermission.message", (Object)"\u00a7cYou do not have a permission to do that!");
        cfg.set("messages.weapon.load.message", (Object)"\u00a7cThis weapon is loading!");
        cfg.set("order.waitdelay", (Object)5);
        try {
            cfg.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

