/*
 * Decompiled with CFR 0.152.
 */
package me.kozs.mc.gapple.objects;

import java.time.Instant;
import me.kozs.mc.gapple.AppleType;
import me.kozs.mc.gapple.config.ConfigSettings;

public class GoldenAppleCD {
    private long totalstartCD;
    private long gApplestartCD;
    private long egApplestartCD;
    public boolean both = false;
    public boolean gApple = false;
    public boolean egApple = false;

    public GoldenAppleCD(AppleType apple) {
        this.restrictApple(apple);
    }

    public void restrictApple(AppleType apple) {
        switch (apple) {
            case BOTH: {
                this.totalstartCD = Instant.now().getEpochSecond();
                this.both = true;
                break;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                this.egApplestartCD = Instant.now().getEpochSecond();
                this.egApple = true;
                break;
            }
            case GOLDEN_APPLE: {
                this.gApplestartCD = Instant.now().getEpochSecond();
                this.gApple = true;
            }
        }
    }

    public boolean isRestricted(AppleType apple) {
        switch (apple) {
            case BOTH: {
                return this.both;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return this.egApple;
            }
            case GOLDEN_APPLE: {
                return this.gApple;
            }
        }
        return false;
    }

    public boolean canEat(AppleType apple) {
        switch (apple) {
            case BOTH: {
                return this.getCDTime(apple) > (long)ConfigSettings.TOTALCDSECS;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return this.getCDTime(apple) > (long)ConfigSettings.EGAPPLECDSECS;
            }
            case GOLDEN_APPLE: {
                return this.getCDTime(apple) > (long)ConfigSettings.GAPPLECDSECS;
            }
        }
        return false;
    }

    public long getCDTime(AppleType apple) {
        switch (apple) {
            case BOTH: {
                return Instant.now().getEpochSecond() - this.totalstartCD;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return Instant.now().getEpochSecond() - this.egApplestartCD;
            }
            case GOLDEN_APPLE: {
                return Instant.now().getEpochSecond() - this.gApplestartCD;
            }
        }
        return 0L;
    }
}

