/*
 * Decompiled with CFR 0.152.
 */
package me.kozs.mc.gapple.objects;

import java.time.Instant;
import me.kozs.mc.gapple.AppleType;
import me.kozs.mc.gapple.config.ConfigSettings;

public class CDDetector {
    private int totalAppleCount;
    private long totallastTimeStamp;
    private int gAppleCount;
    private long glastTimeStamp;
    private int egAppleCount;
    private long eglastTimeStamp;

    boolean appleCountVerified(AppleType apple) {
        switch (apple) {
            case ENCHANTED_GOLDEN_APPLE: {
                return Instant.now().getEpochSecond() - this.eglastTimeStamp > (long)ConfigSettings.EGAPPLESECS;
            }
            case GOLDEN_APPLE: {
                return Instant.now().getEpochSecond() - this.glastTimeStamp > (long)ConfigSettings.GAPPLESECS;
            }
            case BOTH: {
                return Instant.now().getEpochSecond() - this.totallastTimeStamp > (long)ConfigSettings.TOTALAPPLESECS;
            }
        }
        return false;
    }

    void removeAppleCount(AppleType apple) {
        switch (apple) {
            case ENCHANTED_GOLDEN_APPLE: {
                this.egAppleCount = 0;
                break;
            }
            case GOLDEN_APPLE: {
                this.gAppleCount = 0;
                break;
            }
            case BOTH: {
                this.totalAppleCount = 0;
            }
        }
    }

    public int getAppleCount(AppleType apple) {
        switch (apple) {
            case BOTH: {
                return this.totalAppleCount;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return this.egAppleCount;
            }
            case GOLDEN_APPLE: {
                return this.gAppleCount;
            }
        }
        return 0;
    }

    public void addAppleCount(AppleType apple) {
        if (this.appleCountVerified(apple)) {
            this.removeAppleCount(apple);
        }
        switch (apple) {
            case ENCHANTED_GOLDEN_APPLE: {
                ++this.egAppleCount;
                this.eglastTimeStamp = Instant.now().getEpochSecond();
                break;
            }
            case GOLDEN_APPLE: {
                ++this.gAppleCount;
                this.glastTimeStamp = Instant.now().getEpochSecond();
                break;
            }
            case BOTH: {
                ++this.totalAppleCount;
                this.totallastTimeStamp = Instant.now().getEpochSecond();
                break;
            }
        }
    }

    public int getTotalAppleCount() {
        return this.totalAppleCount;
    }

    public void setTotalAppleCount(int totalAppleCount) {
        this.totalAppleCount = totalAppleCount;
    }

    public int getGappleCount() {
        return this.gAppleCount;
    }

    public void setGappleCount(int gappleCount) {
        this.gAppleCount = gappleCount;
    }

    public int getEgAppleCount() {
        return this.egAppleCount;
    }

    public void setEgAppleCount(int egAppleCount) {
        this.egAppleCount = egAppleCount;
    }

    public long getTotallastTimeStamp() {
        return this.totallastTimeStamp;
    }

    public void setTotallastTimeStamp(long totallastTimeStamp) {
        this.totallastTimeStamp = totallastTimeStamp;
    }

    public long getGlastTimeStamp() {
        return this.glastTimeStamp;
    }

    public void setGlastTimeStamp(long glastTimeStamp) {
        this.glastTimeStamp = glastTimeStamp;
    }

    public long getEglastTimeStamp() {
        return this.eglastTimeStamp;
    }

    public void setEglastTimeStamp(long eglastTimeStamp) {
        this.eglastTimeStamp = eglastTimeStamp;
    }
}

