/*
 * Decompiled with CFR 0.152.
 */
package net.alureon.foundbiome.listener;

import java.util.ArrayList;
import net.alureon.foundbiome.FoundBiome;
import net.alureon.foundbiome.util.BiomeFormatter;
import net.alureon.foundbiome.util.BiomeLists;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class PlayerMoveListener
implements Listener {
    private FoundBiome fb;

    public PlayerMoveListener(FoundBiome fb) {
        this.fb = fb;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().getBiome() != event.getTo().getBlock().getBiome()) {
            ArrayList<Biome> biomeList = this.fb.getMapHandler().getPlayerBiomeList(event.getPlayer());
            Biome newBiome = event.getTo().getBlock().getBiome();
            if (BiomeLists.getDisabledBiomes().contains(newBiome) || BiomeLists.isNonAchievementBiome(newBiome)) {
                return;
            }
            if (!biomeList.contains(newBiome)) {
                biomeList.add(newBiome);
                String message = ChatColor.GREEN + "You've found a " + ChatColor.AQUA + BiomeFormatter.formatBiome(newBiome) + ChatColor.GREEN + " biome!";
                event.getPlayer().sendMessage(message);
                if (this.fb.getFileHandler().getBroadcast()) {
                    for (Player p : this.fb.getServer().getOnlinePlayers()) {
                        if (p == event.getPlayer()) continue;
                        String announcement = event.getPlayer().getDisplayName() + ChatColor.GREEN + " found a " + ChatColor.AQUA + BiomeFormatter.formatBiome(newBiome) + ChatColor.GREEN + " biome!";
                        p.sendMessage(announcement);
                    }
                }
            }
        }
    }
}

