/*
 * Decompiled with CFR 0.152.
 */
package net.alureon.foundbiome.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import net.alureon.foundbiome.FoundBiome;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MapHandler {
    private final HashMap<Player, ArrayList<Biome>> playerMap = new HashMap();
    private FoundBiome fb;

    public MapHandler(FoundBiome fb) {
        this.fb = fb;
    }

    public void addToMap(Player player) {
        ArrayList<Biome> biomes = new ArrayList<Biome>(Biome.values().length);
        JSONParser parser = new JSONParser();
        try {
            String uuid = player.getUniqueId().toString();
            File worldFolder = this.fb.getServer().getWorld(this.fb.getFileHandler().getWorldName()).getWorldFolder();
            Path worldFolderPath = worldFolder.toPath();
            Path statsFile = worldFolderPath.resolve("advancements").resolve(uuid + ".json");
            if (!statsFile.toFile().exists()) {
                System.out.println("Unable to find stats file for player: " + player.getName());
                System.out.println("Path: " + statsFile.toString());
            }
            Object obj = parser.parse(new FileReader(statsFile.toFile()));
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject achievementObject = (JSONObject)jsonObject.get("minecraft:adventure/adventuring_time");
            JSONObject criteriaObject = (JSONObject)achievementObject.get("criteria");
            for (Object o : criteriaObject.keySet()) {
                biomes.add(Biome.valueOf((String)o.toString().toUpperCase()));
            }
            this.playerMap.put(player, biomes);
        }
        catch (FileNotFoundException ex) {
            this.fb.getLogger().severe("Could not find a stats file for player! (maybe they don't have one? creating new map for them)");
            this.playerMap.put(player, biomes);
        }
        catch (ParseException ex) {
            this.fb.getLogger().severe("Failed to parse player json file!");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.fb.getLogger().severe("IOException encountered trying to parse file!");
            ex.printStackTrace();
        }
    }

    public ArrayList<Biome> getPlayerBiomeList(Player player) {
        return this.playerMap.get(player);
    }
}

