/*
 * Decompiled with CFR 0.152.
 */
package net.alureon.foundbiome.command;

import java.util.ArrayList;
import net.alureon.foundbiome.FoundBiome;
import net.alureon.foundbiome.util.BiomeFormatter;
import net.alureon.foundbiome.util.BiomeLists;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private FoundBiome fb;

    public CommandHandler(FoundBiome fb) {
        this.fb = fb;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("fb") && sender instanceof Player) {
            if (args.length == 0) {
                this.sendCommandHelp(sender);
            } else {
                if (args[0].equalsIgnoreCase("current")) {
                    this.sendCurrentBiome(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("seen")) {
                    this.sendSeenBiomes(sender);
                    return true;
                }
                if (args[0].equalsIgnoreCase("unseen")) {
                    this.getUnseenBiomes(sender);
                } else if (args[0].equalsIgnoreCase("version")) {
                    sender.sendMessage(ChatColor.AQUA + this.fb.getDescription().getVersion());
                }
            }
        }
        return false;
    }

    private void sendCommandHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GREEN + "FoundBiome Commands");
        sender.sendMessage(ChatColor.AQUA + "/fb seen     " + ChatColor.WHITE + "-  List biomes you've seen");
        sender.sendMessage(ChatColor.AQUA + "/fb current  " + ChatColor.WHITE + "-  Show your current biome");
        sender.sendMessage(ChatColor.AQUA + "/fb unseen   " + ChatColor.WHITE + "-  List biomes you haven't seen");
    }

    private void getUnseenBiomes(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Biome> playerBiomes = this.fb.getMapHandler().getPlayerBiomeList((Player)sender);
        int i = 0;
        for (Biome b : Biome.values()) {
            if (playerBiomes.contains(b) || BiomeLists.getDisabledBiomes().contains(b) || b.name().startsWith("MUTATED")) continue;
            this.appendColoredBiome(sb, b, i);
            ++i;
        }
        sb.deleteCharAt(sb.length() - 2);
        sender.sendMessage(ChatColor.GREEN + "You haven't seen the following biomes:");
        sender.sendMessage(sb.toString());
    }

    private void sendSeenBiomes(CommandSender sender) {
        if (this.fb.getMapHandler().getPlayerBiomeList((Player)sender).size() == 0) {
            sender.sendMessage(ChatColor.GREEN + "It doesn't look like you've explored much yet");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ChatColor.AQUA);
        int i = 0;
        for (Biome b : this.fb.getMapHandler().getPlayerBiomeList((Player)sender)) {
            this.appendColoredBiome(sb, b, i);
            ++i;
        }
        sb.deleteCharAt(sb.length() - 2);
        sender.sendMessage(ChatColor.GREEN + "You've visited the following biomes:");
        sender.sendMessage(sb.toString());
    }

    private void sendCurrentBiome(CommandSender sender) {
        Biome biome = ((Player)sender).getLocation().getBlock().getBiome();
        sender.sendMessage(ChatColor.GREEN + "You're currently in the following biome:");
        sender.sendMessage(ChatColor.AQUA + BiomeFormatter.formatBiome(biome));
    }

    private void appendColoredBiome(StringBuilder sb, Biome b, int color) {
        if (color % 2 == 0) {
            sb.append(ChatColor.DARK_AQUA);
        } else {
            sb.append(ChatColor.AQUA);
        }
        sb.append(BiomeFormatter.formatBiome(b));
        sb.append(ChatColor.WHITE);
        sb.append(", ");
    }
}

