/*
 * Decompiled with CFR 0.152.
 */
package me.swipez.fishingstructures.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.swipez.fishingstructures.FishingStructures;
import me.swipez.fishingstructures.utils.StructurePlacement;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.TileState;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class StructureUtil {
    private static final Random rng = new Random();

    public static void placeWithDissolutionNEW(String name, final Location placementOrigin, JavaPlugin plugin, LootTable chestsLootTable, EntityType spawnersEntity) {
        File file = new File(plugin.getDataFolder(), "structures/" + name + ".yml");
        YamlConfiguration structureFile = new YamlConfiguration();
        try {
            structureFile.load(file);
        }
        catch (IOException | InvalidConfigurationException exception) {
            exception.printStackTrace();
            return;
        }
        HashMap layerXYsMap = new HashMap();
        HashMap xyPendingZsMap = new HashMap();
        int maxY = Integer.MIN_VALUE;
        HashMap layerBlocksPositionsToPlaceMap = new HashMap();
        for (String xyKey : structureFile.getKeys(true)) {
            if (!xyKey.contains(".") || !xyKey.contains("=")) continue;
            String yPart = xyKey.substring(0, xyKey.indexOf(46));
            int yOffset = Integer.parseInt(yPart.replace("y=", ""));
            String xPart = xyKey.substring(xyKey.indexOf(46) + 1);
            int xOffset = Integer.parseInt(xPart.replace("x=", ""));
            int layer = Integer.parseInt(yPart.replace("y=", ""));
            List allDataPerZ = structureFile.getStringList(xyKey);
            for (String zData : allDataPerZ) {
                int zOffset = Integer.parseInt(zData.substring(0, zData.indexOf(59)));
                xyPendingZsMap.putIfAbsent(xyKey, new ArrayList());
                ((ArrayList)xyPendingZsMap.get(xyKey)).add(zOffset);
                layerBlocksPositionsToPlaceMap.putIfAbsent(layer, new ArrayList());
                ((ArrayList)layerBlocksPositionsToPlaceMap.get(layer)).add(new Vector(xOffset, yOffset, zOffset));
            }
            if (layer > maxY) {
                maxY = layer;
            }
            layerXYsMap.putIfAbsent(layer, new ArrayList());
            ((ArrayList)layerXYsMap.get(layer)).add(xyKey);
        }
        HashMap<Integer, ArrayList<Vector>> layerPendingBlocksMap = new HashMap<Integer, ArrayList<Vector>>(layerBlocksPositionsToPlaceMap);
        int placementDelay = 0;
        boolean firstPass = true;
        while (StructureUtil.isThereSomethingLeftToPlaceNEW(layerPendingBlocksMap)) {
            for (int y = 0; y <= maxY; ++y) {
                ArrayList<Vector> layerPendingBlocks = layerPendingBlocksMap.get(y);
                if (layerPendingBlocks == null || layerPendingBlocks.size() == 0) continue;
                Collections.shuffle(layerPendingBlocks);
                int numBlocks = firstPass ? (int)((double)layerPendingBlocks.size() * 0.5) : Math.max(30, layerPendingBlocks.size() / 4);
                final ArrayList<Vector> blocksToPlace = new ArrayList<Vector>();
                for (int i = 0; i < numBlocks && layerPendingBlocks.size() != 0; ++i) {
                    blocksToPlace.add(layerPendingBlocks.get(0));
                    layerPendingBlocks.remove(0);
                }
                new BukkitRunnable((FileConfiguration)structureFile, placementOrigin, chestsLootTable, spawnersEntity){
                    final /* synthetic */ FileConfiguration val$structureFile;
                    final /* synthetic */ Location val$placementOrigin;
                    final /* synthetic */ LootTable val$chestsLootTable;
                    final /* synthetic */ EntityType val$spawnersEntity;
                    {
                        this.val$structureFile = fileConfiguration;
                        this.val$placementOrigin = location;
                        this.val$chestsLootTable = lootTable;
                        this.val$spawnersEntity = entityType;
                    }

                    public void run() {
                        for (Vector block : blocksToPlace) {
                            String key = "y=" + block.getBlockY() + ".x=" + block.getBlockX();
                            List<TileState> tileEntities = StructureUtil.placeStructureBlock(this.val$structureFile, key, block.getBlockZ(), this.val$placementOrigin).getTileEntities();
                            for (BlockState blockState : tileEntities) {
                                if (this.val$chestsLootTable != null && blockState.getBlock().getType() == Material.CHEST) {
                                    StructureUtil.setLootTable((Chest)blockState, this.val$chestsLootTable);
                                }
                                if (this.val$spawnersEntity == null || blockState.getBlock().getType() != Material.SPAWNER) continue;
                                StructureUtil.setSpawnerType((CreatureSpawner)blockState, this.val$spawnersEntity);
                            }
                        }
                    }
                }.runTaskLater((Plugin)plugin, 1L * (long)(++placementDelay));
            }
            firstPass = false;
        }
        new BukkitRunnable((FileConfiguration)structureFile){
            final /* synthetic */ FileConfiguration val$structureFile;
            {
                this.val$structureFile = fileConfiguration;
            }

            public void run() {
                StructureUtil.spawnMobs(placementOrigin, this.val$structureFile);
            }
        }.runTaskLater((Plugin)plugin, 1L * (long)placementDelay);
    }

    static void spawnMobs(Location origin, FileConfiguration structureFile) {
        Object mobCountObj = structureFile.get("mobcount");
        if (mobCountObj == null) {
            return;
        }
        int mobCount = structureFile.getInt("mobcount");
        for (int i = 0; i < mobCount; ++i) {
            EntityType type = EntityType.valueOf((String)structureFile.getString("mobs." + i + ".type"));
            String stringLoc = structureFile.getString("mobs." + i + ".pos");
            double x = Double.parseDouble(stringLoc.split(";")[0]);
            double y = Double.parseDouble(stringLoc.split(";")[1]);
            double z = Double.parseDouble(stringLoc.split(";")[2]);
            origin.getWorld().spawnEntity(origin.clone().add(x, y, z), type);
        }
    }

    private static boolean isThereSomethingLeftToPlaceNEW(HashMap<Integer, ArrayList<Vector>> layerPendingBlocksMap) {
        for (Map.Entry<Integer, ArrayList<Vector>> entry : layerPendingBlocksMap.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static StructurePlacement placeLayer(FileConfiguration structureFile, Location placementOrigin, int layer) {
        ArrayList<String> coordKeys = new ArrayList<String>();
        for (String key : structureFile.getKeys(true)) {
            String yPart;
            int yOffset;
            if (!key.contains(".") || (yOffset = Integer.parseInt((yPart = key.substring(0, key.indexOf(46))).replace("y=", ""))) != layer) continue;
            coordKeys.add(key);
        }
        return StructureUtil.placeStructure(structureFile, coordKeys, placementOrigin);
    }

    public static StructurePlacement placeStructure(FileConfiguration structureFile, Location placementOrigin) {
        ArrayList<String> coordKeys = new ArrayList<String>();
        for (String key : structureFile.getKeys(true)) {
            if (!key.contains(".")) continue;
            coordKeys.add(key);
        }
        return StructureUtil.placeStructure(structureFile, coordKeys, placementOrigin);
    }

    private static StructurePlacement placeStructureBlock(FileConfiguration structureFile, String xyKey, int z, Location placementOrigin) {
        ArrayList<TileState> tileEntities = new ArrayList<TileState>();
        String yPart = xyKey.substring(0, xyKey.indexOf(46));
        int yOffset = Integer.parseInt(yPart.replace("y=", ""));
        String xPart = xyKey.substring(xyKey.indexOf(46) + 1);
        int xOffset = Integer.parseInt(xPart.replace("x=", ""));
        for (String zPart : structureFile.getStringList(xyKey)) {
            int zOffset = Integer.parseInt(zPart.substring(0, zPart.indexOf(59)));
            if (z != zOffset) continue;
            String blockDataStr = zPart.substring(zPart.indexOf(59) + 1);
            Location placement = placementOrigin.clone();
            placement = placement.add((double)(-xOffset), (double)yOffset, (double)(-zOffset));
            placement.getBlock().setBlockData(Bukkit.getServer().createBlockData(blockDataStr), false);
            if (placement.getBlock().getState() instanceof TileState) {
                tileEntities.add((TileState)placement.getBlock().getState());
            }
            if (placement.getBlock().getType() == Material.YELLOW_CONCRETE) {
                placement.getBlock().setType(Material.AIR);
            }
            if (z != zOffset) continue;
            break;
        }
        return new StructurePlacement(tileEntities);
    }

    private static StructurePlacement placeStructure(FileConfiguration structureFile, List<String> serializedCoordinates, Location placementOrigin) {
        ArrayList<TileState> tileEntities = new ArrayList<TileState>();
        for (String key : serializedCoordinates) {
            String yPart = key.substring(0, key.indexOf(46));
            int yOffset = Integer.parseInt(yPart.replace("y=", ""));
            String xPart = key.substring(key.indexOf(46) + 1);
            int xOffset = Integer.parseInt(xPart.replace("x=", ""));
            for (String zPart : structureFile.getStringList(key)) {
                int zOffset = Integer.parseInt(zPart.substring(0, zPart.indexOf(59)));
                String blockDataStr = zPart.substring(zPart.indexOf(59) + 1);
                Location placement = placementOrigin.clone();
                placement = placement.add((double)(-xOffset), (double)yOffset, (double)(-zOffset));
                placement.getBlock().setBlockData(Bukkit.getServer().createBlockData(blockDataStr), false);
                if (placement.getBlock().getState() instanceof TileState) {
                    tileEntities.add((TileState)placement.getBlock().getState());
                }
                if (placement.getBlock().getType() != Material.YELLOW_CONCRETE) continue;
                placement.getBlock().setType(Material.AIR);
            }
        }
        return new StructurePlacement(tileEntities);
    }

    public static void loadAndSlowlyPlace(String name, Location placementOrigin, int maxY, EntityType spawnersEntity, LootTable chestsLootTable, JavaPlugin plugin) {
        File file = new File(plugin.getDataFolder(), "structures/" + name + ".yml");
        YamlConfiguration fileConfiguration = new YamlConfiguration();
        try {
            fileConfiguration.load(file);
        }
        catch (IOException | InvalidConfigurationException exception) {
            exception.printStackTrace();
            return;
        }
        for (int y = 0; y <= maxY; ++y) {
            int layer = y;
            new BukkitRunnable((FileConfiguration)fileConfiguration, placementOrigin, layer, chestsLootTable, spawnersEntity){
                final /* synthetic */ FileConfiguration val$fileConfiguration;
                final /* synthetic */ Location val$placementOrigin;
                final /* synthetic */ int val$layer;
                final /* synthetic */ LootTable val$chestsLootTable;
                final /* synthetic */ EntityType val$spawnersEntity;
                {
                    this.val$fileConfiguration = fileConfiguration;
                    this.val$placementOrigin = location;
                    this.val$layer = n;
                    this.val$chestsLootTable = lootTable;
                    this.val$spawnersEntity = entityType;
                }

                public void run() {
                    List<TileState> tileEntities = StructureUtil.placeLayer(this.val$fileConfiguration, this.val$placementOrigin, this.val$layer).getTileEntities();
                    for (BlockState blockState : tileEntities) {
                        if (this.val$chestsLootTable != null && blockState.getBlock().getType() == Material.CHEST) {
                            StructureUtil.setLootTable((Chest)blockState, this.val$chestsLootTable);
                        }
                        if (this.val$spawnersEntity == null || blockState.getBlock().getType() != Material.SPAWNER) continue;
                        StructureUtil.setSpawnerType((CreatureSpawner)blockState, this.val$spawnersEntity);
                    }
                }
            }.runTaskLater((Plugin)plugin, 5L * (long)y);
        }
    }

    public static void setLootTable(final Chest chest, final LootTable lootTable) {
        new BukkitRunnable(){

            public void run() {
                chest.setLootTable(lootTable);
                chest.update(true);
            }
        }.runTaskLater((Plugin)FishingStructures.plugin, 1L);
    }

    public static void setSpawnerType(CreatureSpawner spawner, EntityType entityType) {
        spawner.setMaxSpawnDelay(300);
        spawner.setMaxNearbyEntities(6);
        spawner.setSpawnedType(entityType);
        spawner.update();
    }
}

