/*
 * Decompiled with CFR 0.152.
 */
package me.swipez.fishingstructures;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.swipez.fishingstructures.FishingListener;
import me.swipez.fishingstructures.FishingRods;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FishingStructures
extends JavaPlugin {
    public static FishingStructures plugin;

    public void onEnable() {
        File directory;
        plugin = this;
        File mainPath = new File(plugin.getDataFolder().getPath());
        if (!mainPath.exists()) {
            mainPath.mkdir();
        }
        if (!(directory = new File(plugin.getDataFolder() + "/structures")).exists()) {
            directory.mkdir();
        }
        this.exportAllResourceLocales();
        this.getServer().getPluginManager().registerEvents((Listener)new FishingListener(), (Plugin)this);
        FishingRods.initRecipes();
    }

    public void onDisable() {
    }

    private void exportAllResourceLocales() {
        Iterator<Path> pathIterator = this.getAllPathsWithinLocales();
        if (pathIterator == null) {
            return;
        }
        while (pathIterator.hasNext()) {
            Path localePath = pathIterator.next();
            InputStream resourceStream = plugin.getResource(localePath.toString().replace("/structures", "structures"));
            if (resourceStream == null) {
                plugin.getLogger().log(Level.SEVERE, "Could not load resource " + localePath.toString());
                continue;
            }
            try {
                File outFile = new File(plugin.getDataFolder() + "/structures/" + localePath.getFileName());
                if (outFile.exists()) continue;
                Path outPath = outFile.toPath();
                Files.copy(resourceStream, outPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                plugin.getLogger().log(Level.SEVERE, "Could not copy to " + localePath.toString());
                ex.printStackTrace();
            }
        }
    }

    private Iterator<Path> getAllPathsWithinLocales() {
        Stream<Path> walker;
        Path localesPath;
        URI uri;
        try {
            uri = ((Object)((Object)plugin)).getClass().getResource("/structures").toURI();
        }
        catch (URISyntaxException ex) {
            plugin.getLogger().log(Level.SEVERE, "Got invalid URI Syntax from /structures folder");
            return null;
        }
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem;
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException ignored) {
                try {
                    fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                }
                catch (IOException ex) {
                    plugin.getLogger().log(Level.SEVERE, "Error enumerating resources");
                    ex.printStackTrace();
                    return null;
                }
            }
            localesPath = fileSystem.getPath("/structures", new String[0]);
        } else {
            localesPath = Paths.get(uri);
        }
        try {
            walker = Files.walk(localesPath, 1, new FileVisitOption[0]);
        }
        catch (IOException ex) {
            plugin.getLogger().log(Level.SEVERE, "Error enumerating resources");
            ex.printStackTrace();
            return null;
        }
        return walker.iterator();
    }
}

