/*
 * Decompiled with CFR 0.152.
 */
package me.swipez.fishingstructures;

import me.swipez.fishingstructures.FishingStructures;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class FishingRods {
    public static ItemStack VILLAGE_ROD = FishingRods.generateFishingRod("Village Fishing Rod", 1);
    public static ItemStack SHIPWRECK_ROD = FishingRods.generateFishingRod("Ship Wreck Fishing Rod", 2);
    public static ItemStack RUINED_PORTAL_ROD = FishingRods.generateFishingRod("Ruined Portal Fishing Rod", 3);
    public static ItemStack DESERT_TEMPLE_ROD = FishingRods.generateFishingRod("Desert Temple Fishing Rod", 4);
    public static ItemStack SPAWNER_ROOM = FishingRods.generateFishingRod("Spawner Room Fishing Rod", 5);
    public static ItemStack IGLOO_ROD = FishingRods.generateFishingRod("Igloo Fishing Rod", 9);
    public static ItemStack FORTRESS_ROD = FishingRods.generateFishingRod("Nether Fortress Fishing Rod", 6);
    public static ItemStack BASTION_ROD = FishingRods.generateFishingRod("Bastion Fishing Rod", 7);
    public static ItemStack STRONGHOLD_ROD = FishingRods.generateFishingRod("Stronghold Fishing Rod", 8);

    public static void initRecipes() {
        FishingRods.makeFishingRodSurround("village_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Tag.LOGS), VILLAGE_ROD);
        FishingRods.makeFishingRodSurround("shipwreck_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Tag.ITEMS_BOATS), SHIPWRECK_ROD);
        FishingRods.makeFishingRodSurround("ruined_portal_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.FLINT_AND_STEEL), RUINED_PORTAL_ROD);
        FishingRods.makeFishingRodSurround("desert_temple_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.SANDSTONE), DESERT_TEMPLE_ROD);
        FishingRods.makeFishingRodSurround("spawner_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ROTTEN_FLESH), SPAWNER_ROOM);
        FishingRods.makeFishingRodSurround("igloo_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.SNOW_BLOCK), IGLOO_ROD);
        FishingRods.makeFishingRodSurround("fortress_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.NETHER_BRICKS), FORTRESS_ROD);
        FishingRods.makeFishingRodSurround("bastion_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.BLACKSTONE), BASTION_ROD);
        FishingRods.makeFishingRodSurround("stronghold_rod", (RecipeChoice)new RecipeChoice.MaterialChoice(Material.ENDER_EYE), STRONGHOLD_ROD);
    }

    private static void makeFishingRodSurround(String key, RecipeChoice surroundMaterial, ItemStack result) {
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)FishingStructures.plugin, key), result).shape(new String[]{"III", "IFI", "III"}).setIngredient('I', surroundMaterial).setIngredient('F', Material.FISHING_ROD);
        Bukkit.addRecipe((Recipe)recipe);
    }

    private static ItemStack generateFishingRod(String name, int modelData) {
        ItemStack itemStack = new ItemStack(Material.FISHING_ROD);
        ItemMeta meta = itemStack.getItemMeta();
        meta.setDisplayName(ChatColor.LIGHT_PURPLE + name);
        meta.setCustomModelData(Integer.valueOf(modelData));
        itemStack.setItemMeta(meta);
        return itemStack;
    }
}

