/*
 * Decompiled with CFR 0.152.
 */
package dev.timecoding.fasterascend.listener;

import dev.timecoding.fasterascend.FasterAscend;
import dev.timecoding.fasterascend.config.ConfigHandler;
import dev.timecoding.fasterascend.event.OnAscendBoost;
import dev.timecoding.fasterascend.event.OnAscendEnd;
import dev.timecoding.fasterascend.event.OnAscendStart;
import dev.timecoding.fasterascend.event.OnInstantAscendAnimationEnd;
import dev.timecoding.fasterascend.event.OnInstantAscendAnimationStart;
import dev.timecoding.fasterascend.event.OnInstantTeleport;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class FAApiListener
implements Listener {
    private FasterAscend plugin;
    private ConfigHandler configHandler;

    public FAApiListener(FasterAscend plugin) {
        this.plugin = plugin;
        this.configHandler = this.plugin.getConfigHandler();
    }

    @EventHandler
    public void onAscendStart(OnAscendStart e) {
        this.triggerConfigEvents(e.getPlayer(), "OnAscendStart");
    }

    @EventHandler
    public void onAscendEnd(OnAscendEnd e) {
        this.triggerConfigEvents(e.getPlayer(), "OnAscendEnd");
    }

    @EventHandler
    public void onInstantAscendAnimationStart(OnInstantAscendAnimationStart e) {
        this.triggerConfigEvents(e.getPlayer(), "OnAscendStart");
    }

    @EventHandler
    public void onInstantAscendAnimationEnd(OnInstantAscendAnimationEnd e) {
        this.triggerConfigEvents(e.getPlayer(), "OnAscendEnd");
    }

    @EventHandler
    public void onAscendBoost(OnAscendBoost e) {
        this.triggerConfigEvents(e.getPlayer(), "OnAscendBoost");
    }

    @EventHandler
    public void onInstantTeleport(OnInstantTeleport e) {
        this.triggerConfigEvents(e.getPlayer(), "OnInstantTeleport");
    }

    public void triggerConfigEvents(Player p, String argname) {
        String arg = "Events." + argname + ".";
        if (this.configHandler.getBoolean(arg + "Enabled").booleanValue()) {
            p.sendMessage(String.valueOf(this.getObjectWithPlaceholders(this.configHandler.getString(arg + "Message"), p)));
            if (!this.plugin.isActionbarDisabled()) {
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)String.valueOf(this.getObjectWithPlaceholders(this.configHandler.getString(arg + "Message"), p))));
            }
            p.playSound(p.getLocation(), Sound.valueOf((String)this.configHandler.getString(arg + "Sound.Name")), (float)this.configHandler.getInteger(arg + "Sound.Volume").intValue(), (float)this.configHandler.getInteger(arg + "Sound.Pitch").intValue());
        }
    }

    public Object getObjectWithPlaceholders(Object o, Player p) {
        String edited = String.valueOf(o);
        Block b = p.getLocation().getBlock();
        return edited.replace("%player%", p.getName()).replace("%block_name_lowercase%", b.getType().toString().toLowerCase()).replace("%block_name_uppercase%", b.getType().toString().toUpperCase());
    }
}

