/*
 * Decompiled with CFR 0.152.
 */
package dev.timecoding.fasterascend.listener;

import dev.timecoding.fasterascend.FasterAscend;
import dev.timecoding.fasterascend.config.ConfigHandler;
import dev.timecoding.fasterascend.event.OnAscendBoost;
import dev.timecoding.fasterascend.event.OnAscendEnd;
import dev.timecoding.fasterascend.event.OnAscendStart;
import dev.timecoding.fasterascend.event.OnInstantAscendAnimationEnd;
import dev.timecoding.fasterascend.event.OnInstantAscendAnimationStart;
import dev.timecoding.fasterascend.event.OnInstantTeleport;
import dev.timecoding.fasterascend.event.enums.FAAPIArg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class AscendListener
implements Listener {
    private FasterAscend plugin;
    private ConfigHandler configHandler;
    private HashMap<Player, Location> before = new HashMap();
    private HashMap<Player, Integer> savedHigh = new HashMap();
    private ArrayList<Player> needinput = new ArrayList();
    private ArrayList<Player> wasonground = new ArrayList();
    private ArrayList<Player> isonground = new ArrayList();
    private ArrayList<Player> apitriggered = new ArrayList();
    private ArrayList<Player> instantanimation = new ArrayList();

    public AscendListener(FasterAscend plugin) {
        this.plugin = plugin;
        this.configHandler = this.plugin.getConfigHandler();
    }

    public void setBefore(Player p, Location loc) {
        if (this.before.containsKey(p)) {
            this.before.remove(p);
        }
        this.before.put(p, loc);
    }

    public void removeBefore(Player p) {
        if (this.before.containsKey(p)) {
            this.before.remove(p);
        }
    }

    public Location getBefore(Player p) {
        if (this.before.containsKey(p)) {
            return this.before.get(p);
        }
        return null;
    }

    public boolean fixScaffholdings(Player p, Material m) {
        Boolean scaffAllowed = this.plugin.areScaffholdingsAllowed();
        Boolean scaffBugFix = this.configHandler.getBoolean("FixScaffholdings");
        return scaffAllowed != false && scaffBugFix != false && m.equals((Object)Material.SCAFFOLDING) && p.isSneaking();
    }

    @EventHandler
    public void onMove(final PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        Location loc = p.getEyeLocation().subtract(0.0, 1.0, 0.0);
        Block block = loc.getBlock();
        Material posm = block.getType();
        this.isonground.remove(p);
        if (!this.fixScaffholdings(p, posm)) {
            if (this.materialAllowed(posm) && !this.isInBlacklist(p)) {
                Location before;
                if (this.getBefore(p) == null) {
                    this.setBefore(p, loc);
                }
                if ((before = this.getBefore(p)) != loc) {
                    this.setBefore(p, loc);
                    Location subtract = loc.subtract(0.0, 1.0, 0.0);
                    Material m = subtract.getBlock().getType();
                    if (this.materialAllowed(m)) {
                        if (loc.getY() > before.getY() && this.highIsValid(p)) {
                            if (!this.apitriggered.contains(p)) {
                                this.triggerAPIEvent(FAAPIArg.OnAscendStart, p);
                                this.apitriggered.add(p);
                            }
                            if (p.getLocation().getY() >= (double)(this.getHighestPointOnLadder(p.getLocation()) - 1)) {
                                if (this.instantanimation.contains(p)) {
                                    this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationEnd, p);
                                } else {
                                    this.triggerAPIEvent(FAAPIArg.OnAscendEnd, p);
                                }
                                this.instantanimation.remove(p);
                                this.apitriggered.remove(p);
                                this.savedHigh.remove(p);
                            }
                            double speed = 0.1 * (double)this.getCustomSpeed(posm).intValue();
                            if (this.configHandler.getBoolean("RightClick.Enabled").booleanValue() && this.wasonground.contains(p) || this.configHandler.getBoolean("ShiftMode.Enabled").booleanValue() && this.wasonground.contains(p)) {
                                p.setVelocity(p.getVelocity().setY(speed));
                                if (p.getLocation().getY() >= (double)(this.getHighestPointOnLadder(p.getLocation()) - 1)) {
                                    this.wasonground.remove(p);
                                }
                            }
                            if (!this.configHandler.getBoolean("InstantClimbUp.Enabled").booleanValue() || this.configHandler.getBoolean("InstantClimbUp.Enabled").booleanValue() && this.configHandler.getBoolean("InstantClimbUp.DontDisableNormalBoost").booleanValue() && !this.wasonground.contains(p)) {
                                if (this.needinput.contains(p)) {
                                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            if (e.getFrom().getY() < e.getTo().getY()) {
                                                AscendListener.this.needinput.remove(p);
                                            }
                                        }
                                    }, (long)this.getCustomDelay(posm).intValue());
                                } else {
                                    this.triggerAPIEvent(FAAPIArg.OnAscendBoost, p);
                                    p.setVelocity(p.getVelocity().setY(speed));
                                    this.needinput.add(p);
                                }
                            } else if (!this.configHandler.getBoolean("InstantClimbUp.OnlyOnGround").booleanValue()) {
                                if (this.configHandler.getBoolean("InstantClimbUp.WithAnimation").booleanValue()) {
                                    if (!this.instantanimation.contains(p)) {
                                        this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationStart, p);
                                        this.instantanimation.add(p);
                                    }
                                    p.setVelocity(p.getVelocity().setY(speed));
                                } else {
                                    Location location = new Location(p.getWorld(), p.getLocation().getX(), (double)this.getHighestPointOnLadder(p.getLocation()).intValue(), p.getLocation().getZ(), p.getLocation().getYaw(), p.getLocation().getPitch());
                                    p.teleport(location);
                                    this.triggerAPIEvent(FAAPIArg.OnInstantTeleport, p);
                                }
                            } else if (this.configHandler.getBoolean("InstantClimbUp.WithAnimation").booleanValue() && this.wasonground.contains(p)) {
                                if (!this.instantanimation.contains(p)) {
                                    this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationStart, p);
                                    this.instantanimation.add(p);
                                }
                                p.setVelocity(p.getVelocity().setY(speed));
                                if (p.getLocation().getY() >= (double)(this.getHighestPointOnLadder(p.getLocation()) - 1)) {
                                    this.wasonground.remove(p);
                                }
                            }
                        }
                    } else if (this.getBefore(p) != null) {
                        this.isonground.add(p);
                        this.removeBefore(p);
                        double speed = 0.1 * (double)this.getCustomSpeed(posm).intValue();
                        if (this.configHandler.getBoolean("InstantClimbUp.Enabled").booleanValue() && this.configHandler.getBoolean("InstantClimbUp.OnlyOnGround").booleanValue()) {
                            if (this.configHandler.getBoolean("InstantClimbUp.WithAnimation").booleanValue()) {
                                if (!this.instantanimation.contains(p)) {
                                    if (!this.instantanimation.contains(p)) {
                                        this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationStart, p);
                                        this.instantanimation.add(p);
                                    }
                                    this.instantanimation.add(p);
                                }
                                p.setVelocity(p.getVelocity().setY(speed));
                                if (!this.wasonground.contains(p)) {
                                    this.wasonground.add(p);
                                }
                            } else {
                                Location location = new Location(p.getWorld(), p.getLocation().getX(), (double)this.getHighestPointOnLadder(p.getLocation()).intValue(), p.getLocation().getZ(), p.getLocation().getYaw(), p.getLocation().getPitch());
                                p.teleport(location);
                                this.triggerAPIEvent(FAAPIArg.OnInstantTeleport, p);
                            }
                        }
                    }
                }
            } else {
                this.wasonground.remove(p);
            }
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (this.configHandler.getBoolean("RightClick.Enabled").booleanValue() && this.isonground.contains(p) && !this.isInBlacklist(p) && (this.configHandler.getBoolean("RightClick.OnlyLeft") != false && e.getAction() == Action.LEFT_CLICK_BLOCK || this.configHandler.getBoolean("RightClick.AlsoLeft") != false && this.configHandler.getBoolean("RightClick.OnlyLeft") == false && e.getAction() == Action.RIGHT_CLICK_BLOCK || this.configHandler.getBoolean("RightClick.AlsoLeft") != false && this.configHandler.getBoolean("RightClick.OnlyLeft") == false && e.getAction() == Action.LEFT_CLICK_BLOCK || !this.configHandler.getBoolean("RightClick.AlsoLeft").booleanValue() && !this.configHandler.getBoolean("RightClick.OnlyLeft").booleanValue() && e.getAction() == Action.RIGHT_CLICK_BLOCK) && (this.configHandler.getBoolean("RightClick.WithShift").booleanValue() && p.isSneaking() || !this.configHandler.getBoolean("RightClick.WithShift").booleanValue())) {
            Material posm = e.getClickedBlock().getType();
            double speed = 0.1 * (double)this.getCustomSpeed(posm).intValue();
            if (this.materialAllowed(posm)) {
                if (this.configHandler.getBoolean("RightClick.WithAnimation").booleanValue()) {
                    if (!this.instantanimation.contains(p)) {
                        this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationStart, p);
                        this.instantanimation.add(p);
                    }
                    p.setVelocity(p.getVelocity().setY(speed));
                    if (!this.wasonground.contains(p)) {
                        this.wasonground.add(p);
                    }
                } else {
                    Location location = new Location(p.getWorld(), p.getLocation().getX(), (double)this.getHighestPointOnLadder(p.getLocation()).intValue(), p.getLocation().getZ(), p.getLocation().getYaw(), p.getLocation().getPitch());
                    p.teleport(location);
                    this.triggerAPIEvent(FAAPIArg.OnInstantTeleport, p);
                }
            }
        }
    }

    @EventHandler
    public void onToggleSneak(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        Material posm = p.getLocation().getBlock().getType();
        double speed = 0.1 * (double)this.getCustomSpeed(posm).intValue();
        if (this.configHandler.getBoolean("ShiftMode.Enabled").booleanValue() && !this.isInBlacklist(p) && this.materialAllowed(posm) && !this.isonground.contains(p) && !this.wasonground.contains(p)) {
            if (this.configHandler.getBoolean("ShiftMode.WithAnimation").booleanValue()) {
                if (!this.instantanimation.contains(p)) {
                    this.triggerAPIEvent(FAAPIArg.OnInstantAscendAnimationStart, p);
                    this.instantanimation.add(p);
                }
                p.setVelocity(p.getVelocity().setY(speed));
                if (!this.wasonground.contains(p)) {
                    this.wasonground.add(p);
                }
            } else {
                Location location = new Location(p.getWorld(), p.getLocation().getX(), (double)this.getHighestPointOnLadder(p.getLocation()).intValue(), p.getLocation().getZ(), p.getLocation().getYaw(), p.getLocation().getPitch());
                p.teleport(location);
                this.triggerAPIEvent(FAAPIArg.OnInstantTeleport, p);
            }
        }
    }

    public boolean materialAllowed(Material posm) {
        if (this.configHandler.getBoolean("Blocks.Ladders") != false && posm == Material.LADDER || this.configHandler.getBoolean("Blocks.Vines") != false && posm == Material.VINE || this.configHandler.getBoolean("Blocks.Water").booleanValue() && posm == Material.WATER) {
            return true;
        }
        if (this.plugin.areScaffholdingsAllowed() && this.configHandler.getBoolean("Blocks.Scaffholdings").booleanValue() && posm == Material.SCAFFOLDING) {
            return true;
        }
        if (this.plugin.areExtravinesAllowed()) {
            if (this.configHandler.getBoolean("Blocks.ExtraVines.Weeping").booleanValue() && (posm == Material.WEEPING_VINES || posm == Material.WEEPING_VINES_PLANT)) {
                return true;
            }
            if (this.configHandler.getBoolean("Blocks.ExtraVines.Twisting").booleanValue() && (posm == Material.TWISTING_VINES || posm == Material.TWISTING_VINES_PLANT)) {
                return true;
            }
        }
        return false;
    }

    public Integer getHighestPointOnLadder(Location loc) {
        Integer finali = 0;
        for (int i = loc.getBlockY(); i <= loc.getWorld().getHighestBlockYAt(loc) + 256; ++i) {
            Block b = loc.getWorld().getBlockAt(loc.getBlockX(), i, loc.getBlockZ());
            Material posm = b.getType();
            if (posm == null || !this.materialAllowed(posm)) continue;
            finali = i;
        }
        return finali + 1;
    }

    public Integer getFirstValidY(Location loc) {
        boolean found = false;
        Integer y = loc.getBlockY();
        while (!found) {
            if (!this.materialAllowed(loc.subtract(0.0, (double)y.intValue(), 0.0).getBlock().getType())) {
                found = true;
                continue;
            }
            Integer n = y;
            y = y - 1;
        }
        return y;
    }

    public Integer calculateAscendingBlocks(Location loc, boolean fromGround) {
        Integer blocks = 0;
        Integer highesty = this.getHighestPointOnLadder(loc);
        Integer setI = loc.getBlockY();
        if (fromGround) {
            setI = this.getFirstValidY(loc);
        }
        for (int i = setI.intValue(); i <= highesty; ++i) {
            Location finalLoc = new Location(loc.getWorld(), loc.getX(), (double)i, loc.getZ());
            Block block = finalLoc.getBlock();
            if (this.materialAllowed(block.getType())) {
                Integer n = blocks;
                blocks = blocks + 1;
                continue;
            }
            i = highesty + 1;
        }
        return blocks;
    }

    public boolean highIsValid(Player p) {
        Integer ascend = this.calculateAscendingBlocks(p.getLocation(), true);
        if (!this.savedHigh.containsKey(p)) {
            if (this.configHandler.getBoolean("RequiredLength.Enabled").booleanValue()) {
                if (ascend >= this.configHandler.getInteger("RequiredLength.LengthInBlocks")) {
                    this.savedHigh.put(p, ascend);
                    return true;
                }
                return false;
            }
        } else {
            return true;
        }
        return true;
    }

    public void triggerAPIEvent(FAAPIArg faapiArg, Player p) {
        switch (faapiArg) {
            case OnAscendEnd: {
                OnAscendEnd onAscendEnd = new OnAscendEnd(p);
                if (onAscendEnd.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onAscendEnd);
                break;
            }
            case OnAscendStart: {
                OnAscendStart onAscendStart = new OnAscendStart(p);
                if (onAscendStart.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onAscendStart);
                break;
            }
            case OnAscendBoost: {
                OnAscendBoost onAscendBoost = new OnAscendBoost(p);
                if (onAscendBoost.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onAscendBoost);
                break;
            }
            case OnInstantTeleport: {
                OnInstantTeleport onInstantTeleport = new OnInstantTeleport(p);
                if (onInstantTeleport.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onInstantTeleport);
                break;
            }
            case OnInstantAscendAnimationStart: {
                OnInstantAscendAnimationStart onInstantAscendAnimationStart = new OnInstantAscendAnimationStart(p);
                if (onInstantAscendAnimationStart.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onInstantAscendAnimationStart);
                break;
            }
            case OnInstantAscendAnimationEnd: {
                OnInstantAscendAnimationEnd onInstantAscendAnimationEnd = new OnInstantAscendAnimationEnd(p);
                if (onInstantAscendAnimationEnd.isCancelled()) break;
                Bukkit.getPluginManager().callEvent((Event)onInstantAscendAnimationEnd);
            }
        }
    }

    public boolean customEnabled(Material m) {
        switch (m) {
            case VINE: {
                return this.configHandler.getBoolean("Boost.Custom.Vines.Enabled");
            }
            case WATER: {
                return this.configHandler.getBoolean("Boost.Custom.Water.Enabled");
            }
            case LADDER: {
                return this.configHandler.getBoolean("Boost.Custom.Ladders.Enabled");
            }
        }
        if (this.plugin.areScaffholdingsAllowed() && m == Material.SCAFFOLDING) {
            return this.configHandler.getBoolean("Boost.Custom.Scaffholdings.Enabled");
        }
        if (this.plugin.areExtravinesAllowed() && (m.name().startsWith("WEEPING_VINES") || m.name().startsWith("TWISTING_VINES"))) {
            return this.configHandler.getBoolean("Boost.Custom.ExtraVines.Enabled");
        }
        return false;
    }

    public Integer getCustomSpeed(Material m) {
        if (this.customEnabled(m)) {
            switch (m) {
                case VINE: {
                    return this.configHandler.getInteger("Boost.Custom.Vines.Speed");
                }
                case WATER: {
                    return this.configHandler.getInteger("Boost.Custom.Water.Speed");
                }
                case LADDER: {
                    return this.configHandler.getInteger("Boost.Custom.Ladders.Speed");
                }
            }
        }
        if (this.plugin.areScaffholdingsAllowed() && m == Material.SCAFFOLDING) {
            return this.configHandler.getInteger("Boost.Custom.Scaffholdings.Speed");
        }
        if (this.plugin.areExtravinesAllowed() && (m.name().startsWith("WEEPING_VINES") || m.name().startsWith("TWISTING_VINES"))) {
            return this.configHandler.getInteger("Boost.Custom.ExtraVines.Speed");
        }
        return this.configHandler.getInteger("Boost.Speed");
    }

    public boolean isInBlacklist(Player p) {
        if (this.configHandler.getBoolean("Blacklist.Enabled").booleanValue()) {
            String worldname = p.getWorld().getName();
            List list = this.configHandler.getConfig().getStringList("Blacklist.Worlds");
            if (this.configHandler.getBoolean("Blacklist.ToWhitelist").booleanValue()) {
                return !list.contains(worldname);
            }
            return list.contains(worldname);
        }
        return false;
    }

    public Integer getCustomDelay(Material m) {
        if (this.customEnabled(m)) {
            switch (m) {
                case VINE: {
                    return this.configHandler.getInteger("Boost.Custom.Vines.Delay");
                }
                case WATER: {
                    return this.configHandler.getInteger("Boost.Custom.Water.Delay");
                }
                case LADDER: {
                    return this.configHandler.getInteger("Boost.Custom.Ladders.Delay");
                }
            }
        }
        if (this.plugin.areScaffholdingsAllowed() && m == Material.SCAFFOLDING) {
            return this.configHandler.getInteger("Boost.Custom.Scaffholdings.Delay");
        }
        if (this.plugin.areExtravinesAllowed() && (m.name().startsWith("WEEPING_VINES") || m.name().startsWith("TWISTING_VINES"))) {
            return this.configHandler.getInteger("Boost.Custom.ExtraVines.Delay");
        }
        return this.configHandler.getInteger("Boost.Delay");
    }
}

