/*
 * Decompiled with CFR 0.152.
 */
package dev.timecoding.fasterascend.config;

import dev.timecoding.fasterascend.FasterAscend;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigHandler {
    private FasterAscend plugin;
    private File f = null;
    public YamlConfiguration cfg = null;
    private boolean retry = false;
    private String newconfigversion = "1.1";

    public ConfigHandler(FasterAscend plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.plugin.saveDefaultConfig();
        this.f = new File(this.plugin.getDataFolder(), "config.yml");
        this.cfg = YamlConfiguration.loadConfiguration((File)this.f);
        this.cfg.options().copyDefaults(true);
        this.checkForConfigUpdate();
    }

    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public void save() {
        try {
            this.cfg.save(this.f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getNewestConfigVersion() {
        return this.newconfigversion;
    }

    public boolean configUpdateAvailable() {
        return !this.getNewestConfigVersion().equalsIgnoreCase(this.getString("config-version"));
    }

    public void reload() {
        this.cfg = YamlConfiguration.loadConfiguration((File)this.f);
    }

    public void checkForConfigUpdate() {
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "Checking for config updates...");
        if (this.configUpdateAvailable()) {
            final Map quicksave = this.plugin.getConfigHandler().getConfig().getValues(true);
            File file = new File("plugins//FasterAscend", "config.yml");
            if (file.exists()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "Config Update found! (" + this.getNewestConfigVersion() + ") Updating config...");
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        ConfigHandler.this.plugin.saveResource("config.yml", true);
                        ConfigHandler.this.reload();
                        for (String save : quicksave.keySet()) {
                            if (!ConfigHandler.this.keyExists(save) || quicksave.get(save) == null || save.equalsIgnoreCase("config-version")) continue;
                            ConfigHandler.this.getConfig().set(save, quicksave.get(save));
                        }
                        ConfigHandler.this.save();
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "Config got updated!");
                    }
                }, 50L);
            } else {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "No Config found! Creating a new one...");
                this.plugin.saveResource("config.yml", false);
            }
        } else {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "No config update found!");
        }
    }

    public YamlConfiguration getConfig() {
        return this.cfg;
    }

    public void setString(String key, String value) {
        this.cfg.set(key, (Object)value);
        this.save();
    }

    public Integer getInteger(String key) {
        if (this.keyExists(key)) {
            return this.cfg.getInt(key);
        }
        return null;
    }

    public String getString(String key) {
        if (this.keyExists(key)) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.cfg.getString(key));
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        if (this.keyExists(key)) {
            return this.cfg.getBoolean(key);
        }
        return null;
    }

    public boolean keyExists(String key) {
        return this.cfg.get(key) != null;
    }
}

