/*
 * Decompiled with CFR 0.152.
 */
package dev.timecoding.fasterascend.api.mfnalex;

import dev.timecoding.fasterascend.api.mfnalex.WordUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public class McVersion
implements Comparable<McVersion> {
    private static final McVersion CURRENT_VERSION;
    private static final McVersion v1_17;
    private final int major;
    private final int minor;
    private final int patch;

    public McVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public McVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static McVersion current() {
        return CURRENT_VERSION;
    }

    public boolean hasVersionInNmsPackageName() {
        return !this.isAtLeast(v1_17);
    }

    public boolean isAtLeast(McVersion other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public int compareTo(@Nonnull McVersion other) {
        if (this.major > other.major) {
            return 3;
        }
        if (other.major > this.major) {
            return -3;
        }
        if (this.minor > other.minor) {
            return 2;
        }
        if (other.minor > this.minor) {
            return -2;
        }
        return Integer.compare(this.patch, other.patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        McVersion mcVersion = (McVersion)o;
        return this.major == mcVersion.major && this.minor == mcVersion.minor && this.patch == mcVersion.patch;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        if (this.patch == 0) {
            return this.major + "." + this.minor;
        }
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean isAtLeast(int major, int minor, int patch) {
        return this.isAtLeast(new McVersion(major, minor, patch));
    }

    public boolean isAtLeast(int major, int minor) {
        return this.isAtLeast(new McVersion(major, minor));
    }

    static {
        v1_17 = new McVersion(1, 17);
        int currentMajor = Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[0]);
        int currentMinor = Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[1].split("-")[0]);
        boolean hasPatch = WordUtils.countChar(Bukkit.getBukkitVersion(), '.') == 3;
        int currentPatch = hasPatch ? Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[2].split("-")[0]) : 0;
        CURRENT_VERSION = new McVersion(currentMajor, currentMinor, currentPatch);
    }
}

