/*
 * Decompiled with CFR 0.152.
 */
package dev.timecoding.fasterascend;

import dev.timecoding.fasterascend.api.UpdateChecker;
import dev.timecoding.fasterascend.api.bstats.Metrics;
import dev.timecoding.fasterascend.api.mfnalex.McVersion;
import dev.timecoding.fasterascend.command.FasterAscendCommand;
import dev.timecoding.fasterascend.command.completer.FasterAscendCompleter;
import dev.timecoding.fasterascend.config.ConfigHandler;
import dev.timecoding.fasterascend.listener.AscendListener;
import dev.timecoding.fasterascend.listener.FAApiListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class FasterAscend
extends JavaPlugin {
    private ConfigHandler configHandler;
    private Metrics metrics = null;
    private int metricsid = 17298;
    private int spigotid = 107195;
    private UpdateChecker updateChecker;
    private boolean disable = false;
    private boolean scaffhold = false;
    private boolean extravines = false;
    private boolean actionbardisabled = false;
    private List<String> legacyversions = new ArrayList<String>();

    public void onEnable() {
        this.legacyversions.add("1.13");
        this.legacyversions.add("1.12");
        this.legacyversions.add("1.11");
        this.legacyversions.add("1.10");
        this.legacyversions.add("1.9");
        this.legacyversions.add("1.8");
        this.configHandler = new ConfigHandler(this);
        this.configHandler.init();
        ConsoleCommandSender sender = this.getServer().getConsoleSender();
        if (this.configHandler.getBoolean("Enabled").booleanValue()) {
            Integer baseversion;
            this.updateChecker = new UpdateChecker(this, this.spigotid);
            sender.sendMessage("\u00a7eFasterAscend \u00a7cv" + this.getDescription().getVersion() + " \u00a7agot enabled!");
            String version = McVersion.current().getName();
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(version.split("\\.")));
            if (split.get(1) == null) {
                sender.sendMessage("\u00a7cUnable to get Minecraft-Version! Disabling Plugin...");
                this.disable = true;
            }
            if ((baseversion = Integer.valueOf(split.get(1))) < 19) {
                sender.sendMessage("\u00a7cInformation: To use this plugin I recommend to use the newest Minecraft-Version!");
                sender.sendMessage("\u00a7cTo get support OR REPORT BUGS for the legacy Minecraft-Versions join my discord: https://discord.gg/mf9JNrzh");
            }
            if (baseversion >= 16) {
                this.extravines = true;
                sender.sendMessage("\u00a77Enabled Support for \u00a7cWeeping and Twisting Vines \u00a77(>= Minecraft Version 1.16)");
            }
            if (baseversion >= 14) {
                this.scaffhold = true;
                sender.sendMessage("\u00a77Enabled Support for \u00a7cScaffholding \u00a77(>= Minecraft Version 1.14)");
            }
            if (baseversion < 14) {
                boolean valid = false;
                for (String versions : this.legacyversions) {
                    if (!version.contains(versions)) continue;
                    valid = true;
                    if (!this.isNotForActionBar(versions)) continue;
                    this.actionbardisabled = true;
                    sender.sendMessage("\u00a7cActionbars got disabled, because this plugin isn't using NMS for actionbars! \u00a77(Actionbars are only running on Minecraft-Versions over 1.9 (1.10-1.19))");
                }
                if (!valid) {
                    sender.sendMessage("\u00a7cHey, this plugin is sadly only compatible with the Minecraft versions between \u00a7f1.8 and 1.19\u00a7c! If you a version running on versions below, join my discord: https://discord.gg/mf9JNrzh");
                    this.disable = true;
                }
            }
            if (!this.disable) {
                if (this.configHandler.getBoolean("bStats").booleanValue()) {
                    this.metrics = new Metrics(this, this.metricsid);
                }
                try {
                    if (this.updateChecker.checkForUpdates()) {
                        sender.sendMessage("");
                        sender.sendMessage("\u00a7aA newer version of this plugin is already available! \u00a7e(Version \u00a7c" + this.updateChecker.getLatestVersion() + "\u00a7e)");
                        sender.sendMessage("\u00a7aFor the best experience download it here: \u00a7ehttps://www.spigotmc.org/resources/faster-ascend.107195/");
                        sender.sendMessage("");
                    } else {
                        sender.sendMessage("\u00a7cNo update found! You're ready to go :)");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                PluginManager pluginManager = this.getServer().getPluginManager();
                pluginManager.registerEvents((Listener)new AscendListener(this), (Plugin)this);
                pluginManager.registerEvents((Listener)new FAApiListener(this), (Plugin)this);
                PluginCommand command = this.getCommand("fasterascend");
                command.setExecutor((CommandExecutor)new FasterAscendCommand(this));
                command.setTabCompleter((TabCompleter)new FasterAscendCompleter(this));
            } else {
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
        } else {
            sender.sendMessage("\u00a7cThe plugin got disabled, because someone disabled the plugin in the config.yml!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public boolean isNotForActionBar(String version) {
        return version.contains("1.8") || version.contains("1.9");
    }

    public boolean isActionbarDisabled() {
        return this.actionbardisabled;
    }

    public boolean methodExists(String name) {
        try {
            Bukkit.class.getMethod(name, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void checkForUpdate() {
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public boolean areScaffholdingsAllowed() {
        return this.scaffhold;
    }

    public boolean areExtravinesAllowed() {
        return this.extravines;
    }
}

