/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core.shared;

import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.SharedConfig;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.LoginSource;
import java.util.UUID;
import java.util.logging.Level;

public abstract class JoinManagement<P extends C, C, S extends LoginSource> {
    protected final FastLoginCore<P, C, ?> core;
    protected final AuthPlugin<P> authHook;

    public JoinManagement(FastLoginCore<P, C, ?> core, AuthPlugin<P> authHook) {
        this.core = core;
        this.authHook = authHook;
    }

    public void onLogin(String username, S source) {
        PlayerProfile profile = this.core.getStorage().loadProfile(username);
        if (profile == null) {
            return;
        }
        SharedConfig config = this.core.getConfig();
        String ip = source.getAddress().getAddress().getHostAddress();
        profile.setLastIp(ip);
        try {
            if (profile.getUserId() == -1L) {
                if (this.core.getPendingLogin().remove(ip + username) != null && config.get("secondAttemptCracked", false).booleanValue()) {
                    this.core.getPlugin().getLogger().log(Level.INFO, "Second attempt login -> cracked {0}", username);
                    this.startCrackedSession(source, profile, username);
                    return;
                }
                UUID premiumUUID = null;
                if (config.get("nameChangeCheck", false).booleanValue() || config.get("autoRegister", false).booleanValue()) {
                    premiumUUID = this.core.getApiConnector().getPremiumUUID(username);
                }
                if (premiumUUID == null || !this.checkNameChange(source, username, premiumUUID) && !this.checkPremiumName(source, username, profile)) {
                    if (this.core.getConfig().get("switchMode", false).booleanValue()) {
                        source.kick(this.core.getMessage("switch-kick-message"));
                        return;
                    }
                    this.startCrackedSession(source, profile, username);
                }
            } else if (profile.isPremium()) {
                this.requestPremiumLogin(source, profile, username, true);
            } else {
                this.startCrackedSession(source, profile, username);
            }
        }
        catch (Exception ex) {
            this.core.getPlugin().getLogger().log(Level.SEVERE, "Failed to check premium state", ex);
        }
    }

    private boolean checkPremiumName(S source, String username, PlayerProfile profile) throws Exception {
        this.core.getPlugin().getLogger().log(Level.FINER, "Player {0} uses a premium username", username);
        if (this.core.getConfig().get("autoRegister", false).booleanValue() && (this.authHook == null || !this.authHook.isRegistered(username))) {
            this.requestPremiumLogin(source, profile, username, false);
            return true;
        }
        return false;
    }

    private boolean checkNameChange(S source, String username, UUID premiumUUID) {
        PlayerProfile profile;
        if (this.core.getConfig().get("nameChangeCheck", false).booleanValue() && (profile = this.core.getStorage().loadProfile(premiumUUID)) != null) {
            this.core.getPlugin().getLogger().log(Level.FINER, "Player {0} changed it's username", premiumUUID);
            profile.setPlayerName(username);
            this.requestPremiumLogin(source, profile, username, false);
            return true;
        }
        return false;
    }

    public abstract void requestPremiumLogin(S var1, PlayerProfile var2, String var3, boolean var4);

    public abstract void startCrackedSession(S var1, PlayerProfile var2, String var3);
}

