/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core.shared;

import com.github.games647.fastlogin.core.AuthStorage;
import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.github.games647.fastlogin.core.shared.PlatformPlugin;
import java.util.logging.Level;

public abstract class ForceLoginManagement<P extends C, C, L extends LoginSession, T extends PlatformPlugin<C>>
implements Runnable {
    protected final FastLoginCore<P, C, T> core;
    protected final P player;
    protected L session;

    public ForceLoginManagement(FastLoginCore<P, C, T> core, P player) {
        this.core = core;
        this.player = player;
    }

    @Override
    public void run() {
        if (!this.isOnline(this.player) || this.session == null) {
            return;
        }
        AuthStorage storage = this.core.getStorage();
        PlayerProfile playerProfile = ((LoginSession)this.session).getProfile();
        try {
            if (this.isOnlineMode()) {
                AuthPlugin<P> authPlugin = this.core.getAuthPluginHook();
                if (authPlugin == null) {
                    this.onForceActionSuccess((LoginSession)this.session);
                } else {
                    boolean success = true;
                    String playerName = this.getName(this.player);
                    if (this.core.getConfig().get("autoLogin", true).booleanValue()) {
                        success = ((LoginSession)this.session).needsRegistration() || this.core.getConfig().get("auto-register-unknown", false) != false && !authPlugin.isRegistered(playerName) ? this.forceRegister(this.player) : this.forceLogin(this.player);
                    }
                    if (success) {
                        if (playerProfile != null) {
                            playerProfile.setUuid(((LoginSession)this.session).getUuid());
                            playerProfile.setPremium(true);
                            storage.save(playerProfile);
                        }
                        this.onForceActionSuccess((LoginSession)this.session);
                    }
                }
            } else if (playerProfile != null) {
                playerProfile.setUuid(null);
                playerProfile.setPremium(false);
                storage.save(playerProfile);
            }
        }
        catch (Exception ex) {
            this.core.getPlugin().getLogger().log(Level.WARNING, "ERROR ON FORCE LOGIN", ex);
        }
    }

    public boolean forceRegister(P player) {
        this.core.getPlugin().getLogger().log(Level.INFO, "Register player {0}", this.getName(player));
        String generatedPassword = this.core.getPasswordGenerator().getRandomPassword(player);
        boolean success = this.core.getAuthPluginHook().forceRegister(player, generatedPassword);
        String message = this.core.getMessage("auto-register");
        if (success && message != null) {
            message = message.replace("%password", generatedPassword);
            this.core.getPlugin().sendMessage(player, message);
        }
        return success;
    }

    public boolean forceLogin(P player) {
        this.core.getPlugin().getLogger().log(Level.INFO, "Logging player {0} in", this.getName(player));
        boolean success = this.core.getAuthPluginHook().forceLogin(player);
        if (success) {
            this.core.sendLocaleMessage("auto-login", player);
        }
        return success;
    }

    public abstract void onForceActionSuccess(LoginSession var1);

    public abstract String getName(P var1);

    public abstract boolean isOnline(P var1);

    public abstract boolean isOnlineMode();
}

