/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core.shared;

import com.github.games647.fastlogin.core.AuthStorage;
import com.github.games647.fastlogin.core.CompatibleCacheBuilder;
import com.github.games647.fastlogin.core.SharedConfig;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.github.games647.fastlogin.core.hooks.DefaultPasswordGenerator;
import com.github.games647.fastlogin.core.hooks.PasswordGenerator;
import com.github.games647.fastlogin.core.shared.MojangApiConnector;
import com.github.games647.fastlogin.core.shared.PlatformPlugin;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class FastLoginCore<P extends C, C, T extends PlatformPlugin<C>> {
    protected final Map<String, String> localeMessages = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, Object> pendingLogin = FastLoginCore.buildCache(5, -1);
    private final Set<UUID> pendingConfirms = Sets.newHashSet();
    private final T plugin;
    private SharedConfig sharedConfig;
    private MojangApiConnector apiConnector;
    private AuthStorage storage;
    private PasswordGenerator<P> passwordGenerator = new DefaultPasswordGenerator();
    private AuthPlugin<P> authPlugin;

    public static <K, V> ConcurrentMap<K, V> buildCache(int expireAfterWrite, int maxSize) {
        CompatibleCacheBuilder builder = CompatibleCacheBuilder.newBuilder();
        if (expireAfterWrite > 0) {
            builder.expireAfterWrite(expireAfterWrite, TimeUnit.MINUTES);
        }
        if (maxSize > 0) {
            builder.maximumSize(maxSize);
        }
        return builder.build(CacheLoader.from(() -> {
            throw new UnsupportedOperationException();
        }));
    }

    public static UUID parseId(String withoutDashes) {
        if (withoutDashes == null) {
            return null;
        }
        return UUID.fromString(withoutDashes.substring(0, 8) + '-' + withoutDashes.substring(8, 12) + '-' + withoutDashes.substring(12, 16) + '-' + withoutDashes.substring(16, 20) + '-' + withoutDashes.substring(20, 32));
    }

    public FastLoginCore(T plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.saveDefaultFile("messages.yml");
        this.saveDefaultFile("config.yml");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("config.yml")));
            this.sharedConfig = new SharedConfig(this.plugin.loadYamlFile(reader));
            reader.close();
            reader = Files.newBufferedReader(this.plugin.getDataFolder().toPath().resolve("config.yml"));
            this.sharedConfig.getConfigValues().putAll(this.plugin.loadYamlFile(reader));
            reader.close();
            reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("messages.yml")));
            reader = Files.newBufferedReader(this.plugin.getDataFolder().toPath().resolve("messages.yml"));
            Map<String, Object> messageConfig = this.plugin.loadYamlFile(reader);
            reader.close();
            reader = Files.newBufferedReader(this.plugin.getDataFolder().toPath().resolve("messages.yml"));
            messageConfig.putAll(this.plugin.loadYamlFile(reader));
            for (Map.Entry<String, Object> entry : messageConfig.entrySet()) {
                String message = this.plugin.translateColorCodes('&', (String)entry.getValue());
                if (message.isEmpty()) continue;
                this.localeMessages.put(entry.getKey(), message);
            }
            reader.close();
        }
        catch (IOException ioEx) {
            this.plugin.getLogger().log(Level.INFO, "Failed to load yaml files", ioEx);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
        List ipAddresses = (List)this.sharedConfig.get("ip-addresses");
        int requestLimit = (Integer)this.sharedConfig.get("mojang-request-limit");
        List proxyList = this.sharedConfig.get("proxies", Lists.newArrayList());
        Map<String, Integer> proxies = proxyList.stream().collect(Collectors.toMap(line -> line.split(":")[0], line -> Integer.parseInt(line.split(":")[1])));
        this.apiConnector = this.plugin.makeApiConnector(this.plugin.getLogger(), ipAddresses, requestLimit, proxies);
    }

    public MojangApiConnector getApiConnector() {
        return this.apiConnector;
    }

    public AuthStorage getStorage() {
        return this.storage;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public void sendLocaleMessage(String key, C receiver) {
        String message = this.localeMessages.get(key);
        if (message != null) {
            this.plugin.sendMessage(receiver, message);
        }
    }

    public String getMessage(String key) {
        return this.localeMessages.get(key);
    }

    public boolean setupDatabase() {
        String driver = (String)this.sharedConfig.get("driver");
        String host = this.sharedConfig.get("host", "");
        int port = this.sharedConfig.get("port", 3306);
        String database = (String)this.sharedConfig.get("database");
        String user = this.sharedConfig.get("username", "");
        String password = this.sharedConfig.get("password", "");
        boolean useSSL = this.sharedConfig.get("useSSL", false);
        this.storage = new AuthStorage(this, driver, host, port, database, user, password, useSSL);
        try {
            this.storage.createTables();
            return true;
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to setup database. Disabling plugin...", ex);
            return false;
        }
    }

    public SharedConfig getConfig() {
        return this.sharedConfig;
    }

    public PasswordGenerator<P> getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(PasswordGenerator<P> passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    public ConcurrentMap<String, Object> getPendingLogin() {
        return this.pendingLogin;
    }

    public Collection<UUID> getPendingConfirms() {
        return this.pendingConfirms;
    }

    public AuthPlugin<P> getAuthPluginHook() {
        return this.authPlugin;
    }

    public void setAuthPluginHook(AuthPlugin<P> authPlugin) {
        this.authPlugin = authPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDefaultFile(String fileName) {
        Path configFile;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (Files.notExists(configFile = this.plugin.getDataFolder().toPath().resolve(fileName), new LinkOption[0])) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
            try {
                Files.copy(in, configFile, new CopyOption[0]);
            }
            catch (IOException ioExc) {
                this.plugin.getLogger().log(Level.SEVERE, "Error saving default " + fileName, ioExc);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void close() {
        if (this.storage != null) {
            this.storage.close();
        }
    }
}

