/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class CompatibleCacheBuilder<K, V> {
    private static Method BUILD_METHOD;
    private static Method AS_MAP_METHOD;
    private final CacheBuilder<K, V> builder = CacheBuilder.newBuilder();

    public static <K, V> CompatibleCacheBuilder<K, V> newBuilder() {
        return new CompatibleCacheBuilder<K, V>();
    }

    private CompatibleCacheBuilder() {
    }

    public CompatibleCacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        this.builder.concurrencyLevel(concurrencyLevel);
        return this;
    }

    public CompatibleCacheBuilder<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        this.builder.expireAfterAccess(duration, unit);
        return this;
    }

    public CompatibleCacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        this.builder.expireAfterWrite(duration, unit);
        return this;
    }

    public CompatibleCacheBuilder<K, V> initialCapacity(int initialCapacity) {
        this.builder.initialCapacity(initialCapacity);
        return this;
    }

    public CompatibleCacheBuilder<K, V> maximumSize(int size) {
        this.builder.maximumSize(size);
        return this;
    }

    public <K1 extends K, V1 extends V> CompatibleCacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> listener) {
        this.builder.removalListener(listener);
        return this;
    }

    public CompatibleCacheBuilder<K, V> ticker(Ticker ticker) {
        this.builder.ticker(ticker);
        return this;
    }

    public CompatibleCacheBuilder<K, V> softValues() {
        this.builder.softValues();
        return this;
    }

    public CompatibleCacheBuilder<K, V> weakKeys() {
        this.builder.weakKeys();
        return this;
    }

    public CompatibleCacheBuilder<K, V> weakValues() {
        this.builder.weakValues();
        return this;
    }

    public <K1 extends K, V1 extends V> ConcurrentMap<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        Object cache;
        if (BUILD_METHOD == null) {
            try {
                BUILD_METHOD = this.builder.getClass().getDeclaredMethod("build", CacheLoader.class);
                BUILD_METHOD.setAccessible(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to find CacheBuilder.build(CacheLoader)", e);
            }
        }
        try {
            cache = BUILD_METHOD.invoke(this.builder, loader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke " + BUILD_METHOD + " on " + this.builder, e);
        }
        if (AS_MAP_METHOD == null) {
            try {
                AS_MAP_METHOD = cache.getClass().getMethod("asMap", new Class[0]);
                AS_MAP_METHOD.setAccessible(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to find Cache.asMap() in " + cache, e);
            }
        }
        try {
            return (ConcurrentMap)AS_MAP_METHOD.invoke(cache, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke " + AS_MAP_METHOD + " on " + cache, e);
        }
    }
}

