/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.core;

import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import javax.sql.DataSource;

public class AuthStorage {
    private static final String PREMIUM_TABLE = "premium";
    private final FastLoginCore<?, ?, ?> core;
    private final HikariDataSource dataSource;

    public AuthStorage(FastLoginCore<?, ?, ?> core, String driver, String host, int port, String databasePath, String user, String pass, boolean useSSL) {
        this.core = core;
        HikariConfig config = new HikariConfig();
        config.setUsername(user);
        config.setPassword(pass);
        config.setDriverClassName(driver);
        Properties properties = new Properties();
        properties.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
        properties.setProperty("useSSL", String.valueOf(useSSL));
        config.setDataSourceProperties(properties);
        ThreadFactory platformThreadFactory = core.getPlugin().getThreadFactory();
        if (platformThreadFactory != null) {
            config.setThreadFactory(new ThreadFactoryBuilder().setNameFormat(core.getPlugin().getName() + " Database Pool Thread #%1$d").setDaemon(true).setThreadFactory(platformThreadFactory).build());
        }
        databasePath = databasePath.replace("{pluginDir}", core.getPlugin().getDataFolder().getAbsolutePath());
        String jdbcUrl = "jdbc:";
        if (driver.contains("sqlite")) {
            jdbcUrl = jdbcUrl + "sqlite://" + databasePath;
            config.setConnectionTestQuery("SELECT 1");
        } else {
            jdbcUrl = jdbcUrl + "mysql://" + host + ':' + port + '/' + databasePath;
        }
        config.setJdbcUrl(jdbcUrl);
        this.dataSource = new HikariDataSource(config);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() throws SQLException {
        Connection con = null;
        Statement createStmt = null;
        try {
            con = this.dataSource.getConnection();
            createStmt = con.createStatement();
            String createDataStmt = "CREATE TABLE IF NOT EXISTS premium (UserID INTEGER PRIMARY KEY AUTO_INCREMENT, UUID CHAR(36), Name VARCHAR(16) NOT NULL, Premium BOOLEAN NOT NULL, LastIp VARCHAR(255) NOT NULL, LastLogin TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, UNIQUE (Name) )";
            if (this.dataSource.getJdbcUrl().contains("sqlite")) {
                createDataStmt = createDataStmt.replace("AUTO_INCREMENT", "AUTOINCREMENT");
            }
            createStmt.executeUpdate(createDataStmt);
            try {
                if (this.dataSource.getJdbcUrl().contains("sqlite")) {
                    String tempTableCreate = createDataStmt.replace(PREMIUM_TABLE, "premium_TEMP").replace("IF NOT EXISTS", "");
                    createStmt.executeUpdate(tempTableCreate);
                    createStmt.executeUpdate("INSERT INTO premium_TEMP SELECT * FROM premium");
                    createStmt.executeUpdate("DROP TABLE premium");
                    createStmt.executeUpdate(createDataStmt);
                    createStmt.executeUpdate("INSERT INTO premium SELECT * FROM premium_TEMP");
                } else {
                    createStmt.executeUpdate("ALTER TABLE premium DROP INDEX UUID");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                createStmt.executeUpdate("CREATE INDEX uuid_idx on premium (UUID)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            this.closeQuietly(con);
            this.closeQuietly(createStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerProfile loadProfile(String name) {
        ResultSet resultSet;
        PreparedStatement loadStmt;
        Connection con;
        block5: {
            con = null;
            loadStmt = null;
            resultSet = null;
            con = this.dataSource.getConnection();
            loadStmt = con.prepareStatement("SELECT * FROM premium WHERE Name=? LIMIT 1");
            loadStmt.setString(1, name);
            resultSet = loadStmt.executeQuery();
            if (!resultSet.next()) break block5;
            long userId = resultSet.getInt(1);
            UUID uuid = FastLoginCore.parseId(resultSet.getString(2));
            boolean premium = resultSet.getBoolean(4);
            String lastIp = resultSet.getString(5);
            long lastLogin = resultSet.getTimestamp(6).getTime();
            PlayerProfile playerProfile = new PlayerProfile(userId, uuid, name, premium, lastIp, lastLogin);
            this.closeQuietly(con);
            this.closeQuietly(loadStmt);
            this.closeQuietly(resultSet);
            return playerProfile;
        }
        try {
            PlayerProfile userId = new PlayerProfile(null, name, false, "");
            this.closeQuietly(con);
            this.closeQuietly(loadStmt);
            this.closeQuietly(resultSet);
            return userId;
        }
        catch (SQLException sqlEx) {
            try {
                this.core.getPlugin().getLogger().log(Level.SEVERE, "Failed to query profile", sqlEx);
                this.closeQuietly(con);
                this.closeQuietly(loadStmt);
                this.closeQuietly(resultSet);
            }
            catch (Throwable throwable) {
                this.closeQuietly(con);
                this.closeQuietly(loadStmt);
                this.closeQuietly(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerProfile loadProfile(UUID uuid) {
        Connection con = null;
        PreparedStatement loadStmt = null;
        ResultSet resultSet = null;
        try {
            con = this.dataSource.getConnection();
            loadStmt = con.prepareStatement("SELECT * FROM premium WHERE UUID=? LIMIT 1");
            loadStmt.setString(1, uuid.toString().replace("-", ""));
            resultSet = loadStmt.executeQuery();
            if (resultSet.next()) {
                long userId = resultSet.getInt(1);
                String name = resultSet.getString(3);
                boolean premium = resultSet.getBoolean(4);
                String lastIp = resultSet.getString(5);
                long lastLogin = resultSet.getTimestamp(6).getTime();
                PlayerProfile playerProfile = new PlayerProfile(userId, uuid, name, premium, lastIp, lastLogin);
                this.closeQuietly(con);
                this.closeQuietly(loadStmt);
                this.closeQuietly(resultSet);
                return playerProfile;
            }
            this.closeQuietly(con);
            this.closeQuietly(loadStmt);
            this.closeQuietly(resultSet);
        }
        catch (SQLException sqlEx) {
            try {
                this.core.getPlugin().getLogger().log(Level.SEVERE, "Failed to query profile", sqlEx);
                this.closeQuietly(con);
                this.closeQuietly(loadStmt);
                this.closeQuietly(resultSet);
            }
            catch (Throwable throwable) {
                this.closeQuietly(con);
                this.closeQuietly(loadStmt);
                this.closeQuietly(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(PlayerProfile playerProfile) {
        Connection con = null;
        AutoCloseable updateStmt = null;
        PreparedStatement saveStmt = null;
        ResultSet generatedKeys = null;
        try {
            con = this.dataSource.getConnection();
            UUID uuid = playerProfile.getUuid();
            if (playerProfile.getUserId() == -1L) {
                saveStmt = con.prepareStatement("INSERT INTO premium (UUID, Name, Premium, LastIp) VALUES (?, ?, ?, ?) ", 1);
                if (uuid == null) {
                    saveStmt.setString(1, null);
                } else {
                    saveStmt.setString(1, uuid.toString().replace("-", ""));
                }
                saveStmt.setString(2, playerProfile.getPlayerName());
                saveStmt.setBoolean(3, playerProfile.isPremium());
                saveStmt.setString(4, playerProfile.getLastIp());
                saveStmt.execute();
                generatedKeys = saveStmt.getGeneratedKeys();
                if (generatedKeys != null && generatedKeys.next()) {
                    playerProfile.setUserId(generatedKeys.getInt(1));
                }
            } else {
                saveStmt = con.prepareStatement("UPDATE premium SET UUID=?, Name=?, Premium=?, LastIp=?, LastLogin=CURRENT_TIMESTAMP WHERE UserID=?");
                if (uuid == null) {
                    saveStmt.setString(1, null);
                } else {
                    saveStmt.setString(1, uuid.toString().replace("-", ""));
                }
                saveStmt.setString(2, playerProfile.getPlayerName());
                saveStmt.setBoolean(3, playerProfile.isPremium());
                saveStmt.setString(4, playerProfile.getLastIp());
                saveStmt.setLong(5, playerProfile.getUserId());
                saveStmt.execute();
            }
            boolean bl = true;
            this.closeQuietly(con);
            this.closeQuietly(updateStmt);
            this.closeQuietly(saveStmt);
            this.closeQuietly(generatedKeys);
            return bl;
        }
        catch (SQLException ex) {
            try {
                this.core.getPlugin().getLogger().log(Level.SEVERE, "Failed to save playerProfile", ex);
                this.closeQuietly(con);
                this.closeQuietly(updateStmt);
                this.closeQuietly(saveStmt);
                this.closeQuietly(generatedKeys);
            }
            catch (Throwable throwable) {
                this.closeQuietly(con);
                this.closeQuietly(updateStmt);
                this.closeQuietly(saveStmt);
                this.closeQuietly(generatedKeys);
                throw throwable;
            }
        }
        return false;
    }

    public void close() {
        this.dataSource.close();
    }

    private void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception closeEx) {
                this.core.getPlugin().getLogger().log(Level.SEVERE, "Failed to close connection", closeEx);
            }
        }
    }
}

