/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee.tasks;

import com.github.games647.fastlogin.bungee.FastLoginBungee;
import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class AsyncToggleMessage
implements Runnable {
    private final FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> core;
    private final ProxiedPlayer sender;
    private final String targetPlayer;
    private final boolean toPremium;
    private final boolean isPlayerSender;

    public AsyncToggleMessage(FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> core, ProxiedPlayer sender, String playerName, boolean toPremium, boolean playerSender) {
        this.core = core;
        this.sender = sender;
        this.targetPlayer = playerName;
        this.toPremium = toPremium;
        this.isPlayerSender = playerSender;
    }

    @Override
    public void run() {
        if (this.toPremium) {
            this.activatePremium();
        } else {
            this.turnOffPremium();
        }
    }

    private void turnOffPremium() {
        PlayerProfile playerProfile = this.core.getStorage().loadProfile(this.targetPlayer);
        if (playerProfile.getUserId() != -1L && !playerProfile.isPremium()) {
            this.sendMessage("not-premium");
            return;
        }
        playerProfile.setPremium(false);
        playerProfile.setUuid(null);
        this.core.getStorage().save(playerProfile);
        this.sendMessage("remove-premium");
    }

    private void activatePremium() {
        PlayerProfile playerProfile = this.core.getStorage().loadProfile(this.targetPlayer);
        if (playerProfile.isPremium()) {
            this.sendMessage("already-exists");
            return;
        }
        playerProfile.setPremium(true);
        this.core.getStorage().save(playerProfile);
        this.sendMessage("add-premium");
    }

    private void sendMessage(String localeId) {
        String message = this.core.getMessage(localeId);
        if (this.isPlayerSender) {
            this.sender.sendMessage(TextComponent.fromLegacyText((String)message));
        } else {
            CommandSender console = ProxyServer.getInstance().getConsole();
            console.sendMessage(TextComponent.fromLegacyText((String)message));
        }
    }
}

