/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee.tasks;

import com.github.games647.fastlogin.bungee.BungeeLoginSession;
import com.github.games647.fastlogin.bungee.BungeeLoginSource;
import com.github.games647.fastlogin.bungee.FastLoginBungee;
import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.JoinManagement;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.AsyncEvent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;

public class AsyncPremiumCheck
extends JoinManagement<ProxiedPlayer, CommandSender, BungeeLoginSource>
implements Runnable {
    private final FastLoginBungee plugin;
    private final AsyncEvent<?> preLoginEvent;
    private final PendingConnection connection;

    public AsyncPremiumCheck(FastLoginBungee plugin, AsyncEvent<?> preLoginEvent, PendingConnection connection) {
        super(plugin.getCore(), plugin.getCore().getAuthPluginHook());
        this.plugin = plugin;
        this.preLoginEvent = preLoginEvent;
        this.connection = connection;
    }

    @Override
    public void run() {
        this.plugin.getSession().remove(this.connection);
        InitialHandler initialHandler = (InitialHandler)this.connection;
        String username = initialHandler.getLoginRequest().getData();
        try {
            super.onLogin(username, new BungeeLoginSource(this.connection));
        }
        finally {
            this.preLoginEvent.completeIntent((Plugin)this.plugin);
        }
    }

    @Override
    public void requestPremiumLogin(BungeeLoginSource source, PlayerProfile profile, String username, boolean registered) {
        source.setOnlineMode();
        this.plugin.getSession().put(source.getConnection(), new BungeeLoginSession(username, registered, profile));
        String ip = source.getAddress().getAddress().getHostAddress();
        this.plugin.getCore().getPendingLogin().put(ip + username, new Object());
    }

    @Override
    public void startCrackedSession(BungeeLoginSource source, PlayerProfile profile, String username) {
        this.plugin.getSession().put(source.getConnection(), new BungeeLoginSession(username, false, profile));
    }
}

