/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bungee;

import com.github.games647.fastlogin.bungee.BungeeLoginSession;
import com.github.games647.fastlogin.bungee.MojangApiBungee;
import com.github.games647.fastlogin.bungee.hooks.BungeeAuthHook;
import com.github.games647.fastlogin.bungee.listener.PlayerConnectionListener;
import com.github.games647.fastlogin.bungee.listener.PluginMessageListener;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.MojangApiConnector;
import com.github.games647.fastlogin.core.shared.PlatformPlugin;
import com.google.common.collect.Maps;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.GroupedThreadFactory;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class FastLoginBungee
extends Plugin
implements PlatformPlugin<CommandSender> {
    private final ConcurrentMap<PendingConnection, BungeeLoginSession> session = Maps.newConcurrentMap();
    private FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> core;

    public void onEnable() {
        this.core = new FastLoginCore(this);
        this.core.load();
        if (!this.core.setupDatabase()) {
            return;
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerConnectionListener(this));
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PluginMessageListener(this));
        this.getProxy().registerChannel(this.getDescription().getName());
        this.registerHook();
    }

    public void onDisable() {
        if (this.core != null) {
            this.core.close();
        }
    }

    public FastLoginCore<ProxiedPlayer, CommandSender, FastLoginBungee> getCore() {
        return this.core;
    }

    public ConcurrentMap<PendingConnection, BungeeLoginSession> getSession() {
        return this.session;
    }

    private void registerHook() {
        Plugin plugin = this.getProxy().getPluginManager().getPlugin("BungeeAuth");
        if (plugin != null) {
            this.core.setAuthPluginHook(new BungeeAuthHook());
            this.getLogger().info("Hooked into BungeeAuth");
        }
    }

    @Override
    public String getName() {
        return this.getDescription().getName();
    }

    @Override
    public Map<String, Object> loadYamlFile(Reader reader) {
        ConfigurationProvider configProvider = ConfigurationProvider.getProvider(YamlConfiguration.class);
        Configuration config = configProvider.load(reader);
        return config.getKeys().stream().filter(key -> config.get(key) != null).collect(Collectors.toMap(Function.identity(), arg_0 -> ((Configuration)config).get(arg_0)));
    }

    @Override
    public void sendMessage(CommandSender receiver, String message) {
        receiver.sendMessage(TextComponent.fromLegacyText((String)message));
    }

    @Override
    public String translateColorCodes(char colorChar, String rawMessage) {
        return ChatColor.translateAlternateColorCodes((char)colorChar, (String)rawMessage);
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return new GroupedThreadFactory((Plugin)this, this.getName());
    }

    @Override
    public MojangApiConnector makeApiConnector(Logger logger, List<String> addresses, int requests, Map<String, Integer> proxies) {
        return new MojangApiBungee(logger, addresses, requests, proxies);
    }
}

