/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.tasks;

import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.ForceLoginManagement;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ForceLoginTask
extends ForceLoginManagement<Player, CommandSender, BukkitLoginSession, FastLoginBukkit> {
    public ForceLoginTask(FastLoginCore<Player, CommandSender, FastLoginBukkit> core, Player player) {
        super(core, player);
    }

    @Override
    public void run() {
        String id = '/' + ((Player)this.player).getAddress().getAddress().getHostAddress() + ':' + ((Player)this.player).getAddress().getPort();
        this.session = (LoginSession)((FastLoginBukkit)this.core.getPlugin()).getLoginSessions().remove(id);
        FastLoginBukkit plugin = (FastLoginBukkit)this.core.getPlugin();
        ((Player)this.player).setMetadata(((FastLoginBukkit)this.core.getPlugin()).getName(), (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)true));
        super.run();
    }

    @Override
    public void onForceActionSuccess(LoginSession session) {
        if (((FastLoginBukkit)this.core.getPlugin()).isBungeeCord()) {
            ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
            dataOutput.writeUTF("SUCCESS");
            ((Player)this.player).sendPluginMessage((Plugin)this.core.getPlugin(), ((FastLoginBukkit)this.core.getPlugin()).getName(), dataOutput.toByteArray());
        }
    }

    @Override
    public String getName(Player player) {
        return player.getName();
    }

    @Override
    public boolean isOnline(Player player) {
        try {
            return (Boolean)Bukkit.getScheduler().callSyncMethod((Plugin)this.core.getPlugin(), () -> ((Player)player).isOnline()).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            ((FastLoginBukkit)this.core.getPlugin()).getLogger().log(Level.SEVERE, "Failed to perform thread-safe online check", ex);
            return false;
        }
    }

    @Override
    public boolean isOnlineMode() {
        return ((BukkitLoginSession)this.session).isVerified() && ((Player)this.player).getName().equals(((BukkitLoginSession)this.session).getUsername());
    }
}

