/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.tasks;

import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.bukkit.hooks.AuthMeHook;
import com.github.games647.fastlogin.bukkit.hooks.CrazyLoginHook;
import com.github.games647.fastlogin.bukkit.hooks.LogItHook;
import com.github.games647.fastlogin.bukkit.hooks.LoginSecurityHook;
import com.github.games647.fastlogin.bukkit.hooks.UltraAuthHook;
import com.github.games647.fastlogin.bukkit.hooks.xAuthHook;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class DelayedAuthHook
implements Runnable {
    private final FastLoginBukkit plugin;

    public DelayedAuthHook(FastLoginBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        boolean hookFound;
        boolean bl = hookFound = this.plugin.getCore().getAuthPluginHook() != null || this.registerHooks();
        if (this.plugin.isBungeeCord()) {
            this.plugin.getLogger().info("BungeeCord setting detected. No auth plugin is required");
        } else if (!hookFound) {
            this.plugin.getLogger().warning("No auth plugin were found by this plugin (other plugins could hook into this after the initialization of this plugin)and BungeeCord is deactivated. Either one or both of the checks have to pass in order to use this plugin");
        }
        if (hookFound) {
            this.plugin.setServerStarted();
        }
    }

    private boolean registerHooks() {
        AuthPlugin authPluginHook = null;
        try {
            ArrayList supportedHooks = Lists.newArrayList((Object[])new Class[]{AuthMeHook.class, CrazyLoginHook.class, LogItHook.class, LoginSecurityHook.class, UltraAuthHook.class, xAuthHook.class});
            for (Class clazz : supportedHooks) {
                String pluginName = clazz.getSimpleName().replace("Hook", "");
                if (Bukkit.getServer().getPluginManager().getPlugin(pluginName) == null) continue;
                authPluginHook = (AuthPlugin)clazz.newInstance();
                this.plugin.getLogger().log(Level.INFO, "Hooking into auth plugin: {0}", pluginName);
                break;
            }
        }
        catch (IllegalAccessException | InstantiationException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Couldn't load the integration class", ex);
        }
        if (authPluginHook == null) {
            this.plugin.getLogger().warning("No support offline Auth plugin found. ");
            return false;
        }
        if (this.plugin.getCore().getAuthPluginHook() == null) {
            this.plugin.getCore().setAuthPluginHook(authPluginHook);
        }
        return true;
    }
}

