/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.core.shared.LoginSource;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.Random;
import org.bukkit.entity.Player;

public class ProtocolLibLoginSource
implements LoginSource {
    private static final int VERIFY_TOKEN_LENGTH = 4;
    private final FastLoginBukkit plugin;
    private final PacketEvent packetEvent;
    private final Player player;
    private final Random random;
    private String serverId;
    private final byte[] verifyToken = new byte[4];

    public ProtocolLibLoginSource(FastLoginBukkit plugin, PacketEvent packetEvent, Player player, Random random) {
        this.plugin = plugin;
        this.packetEvent = packetEvent;
        this.player = player;
        this.random = random;
    }

    @Override
    public void setOnlineMode() throws Exception {
        this.serverId = Long.toString(this.random.nextLong(), 16);
        this.random.nextBytes(this.verifyToken);
        this.sentEncryptionRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kick(String message) throws Exception {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer kickPacket = protocolManager.createPacket(PacketType.Login.Server.DISCONNECT);
        kickPacket.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        try {
            protocolManager.sendServerPacket(this.player, kickPacket);
        }
        finally {
            this.player.kickPlayer("Disconnect");
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.packetEvent.getPlayer().getAddress();
    }

    private void sentEncryptionRequest() throws InvocationTargetException {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        PacketContainer newPacket = protocolManager.createPacket(PacketType.Login.Server.ENCRYPTION_BEGIN);
        newPacket.getStrings().write(0, (Object)this.serverId);
        newPacket.getSpecificModifier(PublicKey.class).write(0, (Object)this.plugin.getServerKey().getPublic());
        newPacket.getByteArrays().write(0, (Object)this.verifyToken);
        protocolManager.sendServerPacket(this.player, newPacket);
    }

    public String getServerId() {
        return this.serverId;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }
}

