/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener.protocollib;

import com.comphenix.protocol.reflect.MethodUtils;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

public class LoginSkinApplyListener
implements Listener {
    private static final Class<?> GAME_PROFILE = MinecraftReflection.getGameProfileClass();
    private static final MethodAccessor GET_PROPERTIES = Accessors.getMethodAccessor(GAME_PROFILE, (String)"getProperties", (Class[])new Class[0]);
    private final FastLoginBukkit plugin;

    public LoginSkinApplyListener(FastLoginBukkit plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerLogin(PlayerLoginEvent loginEvent) {
        if (loginEvent.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Player player = loginEvent.getPlayer();
        if (this.plugin.getConfig().getBoolean("forwardSkin")) {
            for (BukkitLoginSession session : this.plugin.getLoginSessions().values()) {
                if (!session.getUsername().equals(player.getName())) continue;
                String signature = session.getSkinSignature();
                String skinData = session.getEncodedSkinData();
                this.applySkin(player, skinData, signature);
                break;
            }
        }
    }

    private void applySkin(Player player, String skinData, String signature) {
        WrappedGameProfile gameProfile = WrappedGameProfile.fromPlayer((Player)player);
        if (skinData != null && signature != null) {
            WrappedSignedProperty skin = WrappedSignedProperty.fromValues((String)"textures", (String)skinData, (String)signature);
            try {
                gameProfile.getProperties().put((Object)"textures", (Object)skin);
            }
            catch (ClassCastException castException) {
                Object map = GET_PROPERTIES.invoke(gameProfile.getHandle(), new Object[0]);
                try {
                    MethodUtils.invokeMethod((Object)map, (String)"put", (Object[])new Object[]{"textures", skin.getHandle()});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error setting premium skin", ex);
                }
            }
        }
    }
}

