/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener;

import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.bukkit.tasks.ForceLoginTask;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeCordListener
implements PluginMessageListener {
    private static final String FILE_NAME = "proxy-whitelist.txt";
    private final FastLoginBukkit plugin;
    private final Set<UUID> proxyIds;

    public BungeeCordListener(FastLoginBukkit plugin) {
        this.plugin = plugin;
        this.proxyIds = this.loadBungeeCordIds();
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        if (!channel.equals(this.plugin.getName())) {
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])message);
        String subChannel = dataInput.readUTF();
        this.plugin.getLogger().log(Level.FINEST, "Received plugin message for sub channel {0} from {1}", new Object[]{subChannel, player});
        String playerName = dataInput.readUTF();
        Player checkedPlayer = this.plugin.getServer().getPlayerExact(playerName);
        if (checkedPlayer != null && !checkedPlayer.hasMetadata(this.plugin.getName())) {
            long mostSignificantBits = dataInput.readLong();
            long leastSignificantBits = dataInput.readLong();
            UUID sourceId = new UUID(mostSignificantBits, leastSignificantBits);
            this.plugin.getLogger().log(Level.FINEST, "Received proxy id {0} from {1}", new Object[]{sourceId, player});
            if (this.proxyIds.contains(sourceId)) {
                this.readMessage(checkedPlayer, subChannel, playerName, player);
            }
        }
    }

    private void readMessage(Player checkedPlayer, String subchannel, String playerName, Player player) {
        InetSocketAddress address = checkedPlayer.getAddress();
        String id = '/' + address.getAddress().getHostAddress() + ':' + address.getPort();
        if ("AUTO_LOGIN".equalsIgnoreCase(subchannel)) {
            BukkitLoginSession playerSession = new BukkitLoginSession(playerName, true);
            playerSession.setVerified(true);
            this.plugin.getLoginSessions().put(id, playerSession);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new ForceLoginTask(this.plugin.getCore(), player));
        } else if ("AUTO_REGISTER".equalsIgnoreCase(subchannel)) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                AuthPlugin<Player> authPlugin = this.plugin.getCore().getAuthPluginHook();
                try {
                    if (authPlugin == null || !authPlugin.isRegistered(playerName)) {
                        BukkitLoginSession playerSession = new BukkitLoginSession(playerName, false);
                        playerSession.setVerified(true);
                        this.plugin.getLoginSessions().put(id, playerSession);
                        new ForceLoginTask(this.plugin.getCore(), player).run();
                    }
                }
                catch (Exception ex) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to query isRegistered", ex);
                }
            });
        }
    }

    public Set<UUID> loadBungeeCordIds() {
        Path whitelistFile = this.plugin.getDataFolder().toPath().resolve(FILE_NAME);
        try {
            if (Files.notExists(whitelistFile, new LinkOption[0])) {
                Files.createFile(whitelistFile, new FileAttribute[0]);
            }
            return Files.lines(whitelistFile).map(String::trim).map(UUID::fromString).collect(Collectors.toSet());
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create file for Proxy whitelist", ex);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to retrieve proxy Id. Disabling BungeeCord support", ex);
        }
        return null;
    }
}

