/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.listener;

import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.bukkit.tasks.ForceLoginTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class BukkitJoinListener
implements Listener {
    private static final long DELAY_LOGIN = 10L;
    private final FastLoginBukkit plugin;

    public BukkitJoinListener(FastLoginBukkit plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent loginEvent) {
        if (loginEvent.getResult() == PlayerLoginEvent.Result.ALLOWED && !this.plugin.isServerFullyStarted()) {
            loginEvent.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.getCore().getMessage("not-started"));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent joinEvent) {
        Player player = joinEvent.getPlayer();
        if (!this.plugin.isBungeeCord()) {
            ForceLoginTask forceLoginTask = new ForceLoginTask(this.plugin.getCore(), player);
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)forceLoginTask, 10L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent quitEvent) {
        Player player = quitEvent.getPlayer();
        player.removeMetadata(this.plugin.getName(), (Plugin)this.plugin);
        this.plugin.getCore().getPendingConfirms().remove(player.getUniqueId());
    }
}

