/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.hooks;

import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ultraauth.api.UltraAuthAPI;
import ultraauth.main.Main;
import ultraauth.managers.PlayerManager;

public class UltraAuthHook
implements AuthPlugin<Player> {
    private final Plugin ultraAuthPlugin = Main.main;

    @Override
    public boolean forceLogin(Player player) {
        Future future = Bukkit.getScheduler().callSyncMethod(this.ultraAuthPlugin, () -> {
            if (UltraAuthAPI.isAuthenticated((Player)player)) {
                return true;
            }
            UltraAuthAPI.authenticatedPlayer((Player)player);
            return UltraAuthAPI.isAuthenticated((Player)player);
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            this.ultraAuthPlugin.getLogger().log(Level.SEVERE, "Failed to forceLogin", ex);
            return false;
        }
    }

    @Override
    public boolean isRegistered(String playerName) throws Exception {
        return UltraAuthAPI.isRegisterd((String)playerName);
    }

    @Override
    public boolean forceRegister(Player player, String password) {
        UltraAuthAPI.setPlayerPasswordOnline((Player)player, (String)password);
        if (PlayerManager.getInstance().checkPlayerPassword(player, password)) {
            return this.forceLogin(player);
        }
        return false;
    }
}

