/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit.hooks;

import com.github.games647.fastlogin.bukkit.FastLoginBukkit;
import com.github.games647.fastlogin.core.hooks.AuthPlugin;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.AuthAction;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.LoginAction;
import com.lenis0012.bukkit.loginsecurity.session.action.RegisterAction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LoginSecurityHook
implements AuthPlugin<Player> {
    private final FastLoginBukkit plugin = (FastLoginBukkit)Bukkit.getPluginManager().getPlugin("FastLogin");

    @Override
    public boolean forceLogin(Player player) {
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        if (session.isAuthorized()) {
            return true;
        }
        return session.performAction((AuthAction)new LoginAction(AuthService.PLUGIN, (Object)this.plugin)).isSuccess();
    }

    @Override
    public boolean isRegistered(String playerName) throws Exception {
        PlayerSession session = LoginSecurity.getSessionManager().getOfflineSession(playerName);
        return session.isRegistered();
    }

    @Override
    public boolean forceRegister(Player player, String password) {
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(player);
        return session.performAction((AuthAction)new RegisterAction(AuthService.PLUGIN, (Object)this.plugin, password)).isSuccess();
    }
}

