/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit;

import com.github.games647.fastlogin.bukkit.BukkitLoginSession;
import com.github.games647.fastlogin.core.shared.FastLoginCore;
import com.github.games647.fastlogin.core.shared.LoginSession;
import com.github.games647.fastlogin.core.shared.MojangApiConnector;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class MojangApiBukkit
extends MojangApiConnector {
    private static final String HAS_JOINED_URL = "https://sessionserver.mojang.com/session/minecraft/hasJoined?username=%s&serverId=%s";

    public MojangApiBukkit(Logger logger, List<String> localAddresses, int rateLimit, Map<String, Integer> proxies) {
        super(logger, localAddresses, rateLimit, proxies);
    }

    @Override
    public boolean hasJoinedServer(LoginSession session, String serverId, InetSocketAddress ip) {
        BukkitLoginSession playerSession = (BukkitLoginSession)session;
        try {
            HttpsURLConnection conn;
            BufferedReader reader;
            String line;
            String url = String.format(HAS_JOINED_URL, playerSession.getUsername(), serverId);
            if (ip != null) {
                url = url + "&ip=" + URLEncoder.encode(ip.getAddress().getHostAddress(), "UTF-8");
            }
            if ((line = (reader = new BufferedReader(new InputStreamReader((conn = this.getConnection(url)).getInputStream()))).readLine()) != null && !"null".equals(line)) {
                JSONObject userData = (JSONObject)JSONValue.parseWithException((String)line);
                String uuid = (String)userData.get((Object)"id");
                playerSession.setUuid(FastLoginCore.parseId(uuid));
                JSONArray properties = (JSONArray)userData.get((Object)"properties");
                JSONObject skinProperty = (JSONObject)properties.get(0);
                String propertyName = (String)skinProperty.get((Object)"name");
                if ("textures".equals(propertyName)) {
                    String skinValue = (String)skinProperty.get((Object)"value");
                    String signature = (String)skinProperty.get((Object)"signature");
                    playerSession.setSkin(skinValue, signature);
                }
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Failed to verify session", ex);
        }
        return false;
    }

    @Override
    protected String getUUIDFromJson(String json) {
        JSONObject mojangPlayer;
        boolean isArray = json.startsWith("[");
        if (isArray) {
            JSONArray array = (JSONArray)JSONValue.parse((String)json);
            mojangPlayer = (JSONObject)array.get(0);
        } else {
            mojangPlayer = (JSONObject)JSONValue.parse((String)json);
        }
        String uuid = (String)mojangPlayer.get((Object)"id");
        if ("null".equals(uuid)) {
            return null;
        }
        return uuid;
    }
}

