/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit;

import com.google.common.base.Charsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtil {
    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException nosuchalgorithmexception) {
            throw new ExceptionInInitializerError(nosuchalgorithmexception);
        }
    }

    public static byte[] getServerIdHash(String serverId, Key publicKey, Key secretKey) {
        return EncryptionUtil.digestOperation("SHA-1", serverId.getBytes(Charsets.ISO_8859_1), secretKey.getEncoded(), publicKey.getEncoded());
    }

    private static byte[] digestOperation(String algorithm, byte[] ... content) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance(algorithm);
            Stream.of(content).forEach(messagedigest::update);
            return messagedigest.digest();
        }
        catch (NoSuchAlgorithmException nosuchalgorithmexception) {
            nosuchalgorithmexception.printStackTrace();
            return null;
        }
    }

    public static SecretKey decryptSharedKey(Key privateKey, byte[] encryptedSharedKey) {
        return new SecretKeySpec(EncryptionUtil.decryptData(privateKey, encryptedSharedKey), "AES");
    }

    public static byte[] decryptData(Key key, byte[] data) {
        return EncryptionUtil.cipherOperation(2, key, data);
    }

    private static byte[] cipherOperation(int operationMode, Key key, byte[] data) {
        try {
            return EncryptionUtil.createCipherInstance(operationMode, key.getAlgorithm(), key).doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            ex.printStackTrace();
            System.err.println("Cipher data failed!");
            return null;
        }
    }

    private static Cipher createCipherInstance(int operationMode, String cipherName, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            cipher.init(operationMode, key);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            ex.printStackTrace();
            System.err.println("Cipher creation failed!");
            return null;
        }
    }

    private EncryptionUtil() {
    }
}

