/*
 * Decompiled with CFR 0.152.
 */
package com.github.games647.fastlogin.bukkit;

import com.github.games647.fastlogin.core.PlayerProfile;
import com.github.games647.fastlogin.core.shared.LoginSession;
import org.apache.commons.lang.ArrayUtils;

public class BukkitLoginSession
extends LoginSession {
    private final String serverId;
    private final byte[] verifyToken;
    private boolean verified;
    private String encodedSkinData;
    private String skinSignature;

    public BukkitLoginSession(String username, String serverId, byte[] verifyToken, boolean registered, PlayerProfile profile) {
        super(username, registered, profile);
        this.serverId = serverId;
        this.verifyToken = ArrayUtils.clone((byte[])verifyToken);
    }

    public BukkitLoginSession(String username, boolean registered) {
        this(username, "", ArrayUtils.EMPTY_BYTE_ARRAY, registered, null);
    }

    public BukkitLoginSession(String username, PlayerProfile profile) {
        this(username, "", ArrayUtils.EMPTY_BYTE_ARRAY, false, profile);
    }

    public String getServerId() {
        return this.serverId;
    }

    public byte[] getVerifyToken() {
        return ArrayUtils.clone((byte[])this.verifyToken);
    }

    public synchronized String getEncodedSkinData() {
        return this.encodedSkinData;
    }

    public synchronized String getSkinSignature() {
        return this.skinSignature;
    }

    public synchronized void setSkin(String encodedData, String skinSignature) {
        this.encodedSkinData = encodedData;
        this.skinSignature = skinSignature;
    }

    public synchronized void setVerified(boolean verified) {
        this.verified = verified;
    }

    public synchronized boolean isVerified() {
        return this.verified;
    }
}

