/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ParsedMap<K, V>
extends HashMap<K, V> {
    public ParsedMap() {
    }

    public ParsedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public <V> V getValue(K key) {
        return this.get(key);
    }

    public <V> V getValue(K key, V defaultValue) {
        return this.get(key) == null ? defaultValue : this.get(key);
    }

    public String getString(K key) {
        return super.get(key).toString();
    }

    public String getString(K key, String defaultValue) {
        return super.get(key).toString() == null ? defaultValue : super.get(key).toString();
    }

    public byte getByte(K key) {
        return Byte.parseByte(this.getString(key));
    }

    public byte getByte(K key, byte defaultValue) {
        return this.getString(key) == null ? defaultValue : Byte.parseByte(this.getString(key));
    }

    public short getShort(K key) {
        return Short.parseShort(this.getString(key));
    }

    public short getShort(K key, short defaultValue) {
        return this.getString(key) == null ? defaultValue : Short.parseShort(this.getString(key));
    }

    public int getInteger(K key) {
        return Integer.parseInt(this.getString(key));
    }

    public int getInteger(K key, int defaultValue) {
        return this.getString(key) == null ? defaultValue : Integer.parseInt(this.getString(key));
    }

    public long getLong(K key) {
        return Long.parseLong(this.getString(key));
    }

    public long getLong(K key, long defaultValue) {
        return this.getString(key) == null ? defaultValue : Long.parseLong(this.getString(key));
    }

    public float getFloat(K key) {
        return Float.parseFloat(this.getString(key));
    }

    public float getFloat(K key, float defaultValue) {
        return this.getString(key) == null ? defaultValue : Float.parseFloat(this.getString(key));
    }

    public double getDouble(K key) {
        return Double.parseDouble(this.getString(key));
    }

    public double getDouble(K key, double defaultValue) {
        return this.getString(key) == null ? defaultValue : Double.parseDouble(this.getString(key));
    }

    public boolean getBoolean(K key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public boolean getBoolean(K key, boolean defaultValue) {
        return this.getString(key) == null ? defaultValue : Boolean.parseBoolean(this.getString(key));
    }

    public char getCharacter(K key) {
        return this.getString(key).charAt(0);
    }

    public char getCharacter(K key, char defaultValue) {
        return this.getString(key) == null ? defaultValue : this.getString(key).charAt(0);
    }

    public UUID getUUID(K key) {
        return UUID.fromString(this.getString(key));
    }

    public List<?> getList(K key) {
        Object searchedObject = this.get(key);
        return searchedObject instanceof List ? (List)searchedObject : null;
    }

    public List<String> getStringList(K key) {
        List<?> list = this.getList(key);
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (!(object instanceof String)) continue;
            result.add((String)object);
        }
        return result;
    }

    public List<Long> getLongList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).longValue());
        }
        return result;
    }

    public List<Integer> getIntList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).intValue());
        }
        return result;
    }

    public List<Short> getShortList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Short> result = new ArrayList<Short>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).shortValue());
        }
        return result;
    }

    public List<Byte> getByteList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).byteValue());
        }
        return result;
    }

    public List<Double> getDoubleList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).doubleValue());
        }
        return result;
    }

    public List<Float> getFloatList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Float> result = new ArrayList<Float>();
        for (Object object : list) {
            if (!(object instanceof Number)) continue;
            result.add(Float.valueOf(((Number)object).floatValue()));
        }
        return result;
    }

    public List<Boolean> getBooleanList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object object : list) {
            if (!(object instanceof Boolean)) continue;
            result.add((Boolean)object);
        }
        return result;
    }

    public List<Character> getCharList(K key) {
        List<?> list = this.getList(key);
        ArrayList<Character> result = new ArrayList<Character>();
        for (Object object : list) {
            if (!(object instanceof Character)) continue;
            result.add((Character)object);
        }
        return result;
    }

    public Map<?, ?> getMap(K key) {
        Object searchedObject = this.get(key);
        return searchedObject instanceof Map ? (Map)searchedObject : null;
    }

    public Map<?, String> getStringMap(K key) {
        Map<?, ?> map = this.getMap(key);
        HashMap result = new HashMap();
        for (Object keyObject : map.keySet()) {
            if (!(map.get(keyObject) instanceof String)) continue;
            result.put(keyObject, (String)map.get(keyObject));
        }
        return result;
    }
}

