/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.io;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Files {
    private Files() {
    }

    public static boolean containsFile(File folder, String fileName) {
        File[] files = folder.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || !files[i].getName().equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }

    public static List<File> getFiles(File folder) {
        if (!folder.isDirectory()) {
            throw new UnsupportedOperationException(folder.getName() + " is not a directory");
        }
        return List.of(Objects.requireNonNull(folder.listFiles()));
    }

    public static List<String> toStringList(File file) {
        return Arrays.stream(Objects.requireNonNull(file.listFiles())).filter(File::isDirectory).map(File::getName).collect(Collectors.toList());
    }
}

