/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.plugin;

import com.dev7ex.common.bukkit.command.BukkitCommand;
import com.dev7ex.common.bukkit.command.BukkitCommandExecutor;
import com.dev7ex.common.bukkit.plugin.PluginProperties;
import com.dev7ex.common.bukkit.plugin.metrics.Metrics;
import com.dev7ex.common.bukkit.plugin.service.PluginService;
import com.dev7ex.common.bukkit.plugin.service.ServiceManager;
import java.io.File;
import java.util.function.Predicate;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginBase
extends JavaPlugin {
    private Metrics metrics;
    private final ServiceManager serviceManager = new ServiceManager((Plugin)this);

    public void createDataFolder() {
        if (super.getDataFolder().exists()) {
            return;
        }
        super.getDataFolder().mkdirs();
    }

    public void createSubFolder(String folderName) {
        File subFolder = new File(this.getDataFolder().getPath() + File.separator + folderName);
        if (!subFolder.exists()) {
            subFolder.mkdirs();
        }
    }

    public void enableMetrics() {
        this.metrics = new Metrics(this, this.getMetricsId());
    }

    public File getSubFolder(String folderName) {
        return new File(this.getDataFolder().getPath() + File.separator + folderName);
    }

    public PluginCommand registerCommand(String command) {
        return super.getServer().getPluginCommand(command);
    }

    public void registerCommand(BukkitCommand bukkitCommand) {
        PluginCommand pluginCommand = super.getCommand(bukkitCommand.getName());
        pluginCommand.setExecutor((CommandExecutor)new BukkitCommandExecutor(bukkitCommand));
        if (!(bukkitCommand instanceof TabCompleter)) {
            return;
        }
        pluginCommand.setTabCompleter((TabCompleter)bukkitCommand);
    }

    public void registerListener(Listener listener) {
        super.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public void registerListenerIf(Listener listener, Predicate<Boolean> predicate) {
        if (predicate.test(true)) {
            super.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    public void registerService(PluginService pluginService) {
        this.serviceManager.registerService(pluginService);
    }

    public void registerServiceIf(PluginService pluginService, Predicate<Boolean> predicate) {
        if (predicate.test(false)) {
            return;
        }
        this.serviceManager.registerService(pluginService);
    }

    public int getResourceId() {
        return ((Object)((Object)this)).getClass().getAnnotation(PluginProperties.class).resourceId();
    }

    public int getMetricsId() {
        return ((Object)((Object)this)).getClass().getAnnotation(PluginProperties.class).metricsId();
    }

    public boolean hasMetrics() {
        return ((Object)((Object)this)).getClass().getAnnotation(PluginProperties.class).metrics();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }
}

