/*
 * Decompiled with CFR 0.152.
 */
package com.dev7ex.common.bukkit.configuration;

import com.dev7ex.common.bukkit.configuration.ConfigurationProperties;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public abstract class ConfigurationBase {
    private File configurationFile;
    private YamlConfiguration yamlConfiguration;
    private final Plugin plugin;

    public ConfigurationBase(Plugin plugin) {
        if (!this.getClass().isAnnotationPresent(ConfigurationProperties.class)) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is missing " + ConfigurationProperties.class);
        }
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.configurationFile = new File(plugin.getDataFolder() + File.separator + this.getFileName());
        this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
    }

    public void createFile() {
        this.configurationFile.createNewFile();
    }

    public void deleteFile() {
        this.configurationFile.delete();
    }

    public void copyFile() {
        this.configurationFile = new File(this.plugin.getDataFolder(), this.getFileName());
        if (this.configurationFile.exists()) {
            return;
        }
        try (InputStream inputStream = this.plugin.getClass().getClassLoader().getResourceAsStream(this.getFileName());){
            Files.copy(inputStream, this.configurationFile.toPath(), new CopyOption[0]);
        }
    }

    public void loadFile() {
        this.yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configurationFile);
    }

    public void saveFile() {
        this.yamlConfiguration.save(this.configurationFile);
    }

    public final String getFileName() {
        return this.getClass().getAnnotation(ConfigurationProperties.class).fileName();
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public YamlConfiguration getFileConfiguration() {
        return this.yamlConfiguration;
    }
}

